/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.LatentCommonAncestorTruePositiveBidirected;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import java.util.List;

public class LatentCommonAncestorFalseNegativeBidirected
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "LCAFNB";
    }

    @Override
    public String getDescription() {
        return "Latent Common Ancestor False Negative Bidirected";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        Graph pag = GraphTransforms.dagToPag(trueGraph);
        int fn = 0;
        List<Node> nodes = trueGraph.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                Edge edge2;
                Node x = nodes.get(i);
                Node y = nodes.get(j);
                if (x.getNodeType() != NodeType.MEASURED || y.getNodeType() != NodeType.MEASURED || !LatentCommonAncestorTruePositiveBidirected.existsLatentCommonAncestor(trueGraph, new Edge(x, y, Endpoint.CIRCLE, Endpoint.CIRCLE)) || (edge2 = estGraph.getEdge(x, y)) == null || edge2 != null && Edges.isBidirectedEdge(edge2) && LatentCommonAncestorTruePositiveBidirected.existsLatentCommonAncestor(trueGraph, edge2)) continue;
                ++fn;
            }
        }
        return fn;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

