/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import java.util.Collections;
import java.util.List;

public class LatentCommonAncestorTruePositiveBidirected
implements Statistic {
    private static final long serialVersionUID = 23L;

    public static boolean existsLatentCommonAncestor(Graph trueGraph, Edge edge) {
        List<Node> nodes = trueGraph.paths().getAncestors(Collections.singletonList(edge.getNode1()));
        nodes.retainAll(trueGraph.paths().getAncestors(Collections.singletonList(edge.getNode2())));
        for (Node c : nodes) {
            if (c.getNodeType() != NodeType.LATENT) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getAbbreviation() {
        return "#X<->Y,X<~~L~~>Y";
    }

    @Override
    public String getDescription() {
        return "Latent Common Ancestor True Positive Bidirected";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        for (Edge edge : estGraph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge) || !LatentCommonAncestorTruePositiveBidirected.existsLatentCommonAncestor(trueGraph, edge)) continue;
            ++tp;
        }
        return tp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

