/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.Node;
import java.util.List;

public class MaximalityCondition
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "MaximalMag";
    }

    @Override
    public String getDescription() {
        return "1 if the maximality condition passes in the MAG, 0 if not";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        Graph pag = estGraph;
        Graph mag = GraphTransforms.pagToMag(estGraph);
        List<Node> nodes = pag.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node y;
                Node x = nodes.get(i);
                if (mag.isAdjacentTo(x, y = nodes.get(j)) || !mag.paths().existsInducingPath(x, y)) continue;
                return 0.0;
            }
        }
        return 1.0;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

