/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import java.util.HashSet;
import java.util.Set;

public class NodesInCyclesRecall
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "NICR";
    }

    @Override
    public String getDescription() {
        return "Node in cycle recall";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        trueGraph = GraphUtils.replaceNodes(trueGraph, estGraph.getNodes());
        Set<Node> inTrue = this.getNodesInCycles(trueGraph);
        Set<Node> inEst = this.getNodesInCycles(estGraph);
        HashSet<Node> tp = new HashSet<Node>(inTrue);
        tp.retainAll(inEst);
        HashSet<Node> fn = new HashSet<Node>(inTrue);
        fn.removeAll(inEst);
        return (double)tp.size() / (double)(tp.size() + fn.size());
    }

    private Set<Node> getNodesInCycles(Graph graph) {
        HashSet<Node> inCycle = new HashSet<Node>();
        for (Node x : graph.getNodes()) {
            if (!graph.paths().existsDirectedPathFromTo(x, x)) continue;
            inCycle.add(x);
        }
        return inCycle;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

