/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;

public class NumBidirectedEdgesEst
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#X<->Y";
    }

    @Override
    public String getDescription() {
        return "Number of <-> edges in estimated";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int numBidirected = 0;
        for (Edge edge : estGraph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            ++numBidirected;
        }
        return numBidirected;
    }

    @Override
    public double getNormValue(double value) {
        return 1.0 - value;
    }
}

