/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.LatentCommonAncestorTruePositiveBidirected;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.Collections;
import java.util.List;

public class NumCommonMeasuredAncestorBidirected
implements Statistic {
    private static final long serialVersionUID = 23L;

    public static boolean existsCommonAncestor(Graph trueGraph, Edge edge) {
        List<Node> nodes = trueGraph.paths().getAncestors(Collections.singletonList(edge.getNode1()));
        nodes.retainAll(trueGraph.paths().getAncestors(Collections.singletonList(edge.getNode2())));
        return !nodes.isEmpty();
    }

    @Override
    public String getAbbreviation() {
        return "#X<->Y,X<~~MnotL~~>Y";
    }

    @Override
    public String getDescription() {
        return "# X<->Y where X<~~M~~>Y in true but not X<~~L~~>Y";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        int fp = 0;
        for (Edge edge : estGraph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            if (NumCommonMeasuredAncestorBidirected.existsCommonAncestor(trueGraph, edge) && !LatentCommonAncestorTruePositiveBidirected.existsLatentCommonAncestor(trueGraph, edge)) {
                ++tp;
                continue;
            }
            ++fp;
        }
        return tp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

