/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;

public class NumCompatibleVisibleAncestors
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#CVA";
    }

    @Override
    public String getDescription() {
        return "Number compatible visible X-->Y in estimates for which X is an ancestor of Y in true";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        GraphUtils.addPagColoring(estGraph);
        Graph pag = GraphTransforms.dagToPag(trueGraph);
        int tp = 0;
        int fp = 0;
        for (Edge edge : estGraph.getEdges()) {
            Edge trueEdge;
            if (!GraphUtils.compatible(edge, trueEdge = pag.getEdge(edge.getNode1(), edge.getNode2())) || !edge.getProperties().contains((Object)Edge.Property.nl)) continue;
            Node x = Edges.getDirectedEdgeTail(edge);
            Node y = Edges.getDirectedEdgeHead(edge);
            if (trueGraph.paths().isAncestorOf(x, y)) {
                ++tp;
                continue;
            }
            ++fp;
        }
        return tp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

