/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Paths;

public class NumDefinitelyNotDirectedPaths
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#X-->Y-DefNotDir";
    }

    @Override
    public String getDescription() {
        return "Number of X-->Y in est where !semi(X, Y) in true";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int count = 0;
        Graph cpdag = GraphTransforms.cpdagForDag(trueGraph);
        for (Edge edge : estGraph.getEdges()) {
            Node y;
            Node x;
            if (!Edges.isDirectedEdge(edge) || new Paths(cpdag).existsSemiDirectedPath(x = Edges.getDirectedEdgeTail(edge), y = Edges.getDirectedEdgeHead(edge))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

