/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;

public class NumDirectedEdgeVisible
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#X->Y-NL";
    }

    @Override
    public String getDescription() {
        return "Number of X-->Y for which X-->Y visible in true PAG";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        Graph pag = GraphTransforms.dagToPag(trueGraph);
        for (Edge edge : pag.getEdges()) {
            if (!pag.paths().defVisible(edge)) continue;
            ++tp;
        }
        return tp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

