/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.List;

public class NumDirectedPathsTrue
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#X~~>Y(True)";
    }

    @Override
    public String getDescription() {
        return "Number of <X, Y> for which there is a path X~~>Y in the true graph";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        List<Node> nodes = trueGraph.getNodes();
        int count = 0;
        for (Node x : nodes) {
            for (Node y : nodes) {
                if (x == y || !trueGraph.paths().isAncestorOf(x, y)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

