/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.ArrayList;
import java.util.List;

public class PercentAmbiguous
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "%AMB";
    }

    @Override
    public String getDescription() {
        return "Percent Ambiguous Triples";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int numAmbiguous = 0;
        int numTriples = 0;
        List<Node> nodes = estGraph.getNodes();
        for (Node b : nodes) {
            int[] choice;
            ArrayList<Node> adjb = new ArrayList<Node>(estGraph.getAdjacentNodes(b));
            if (adjb.size() < 2) continue;
            ChoiceGenerator gen = new ChoiceGenerator(adjb.size(), 2);
            while ((choice = gen.next()) != null) {
                Node c;
                List<Node> _adj = GraphUtils.asList(choice, adjb);
                Node a = _adj.get(0);
                if (estGraph.isAmbiguousTriple(a, b, c = _adj.get(1))) {
                    ++numAmbiguous;
                }
                ++numTriples;
            }
        }
        return (double)numAmbiguous / (double)numTriples;
    }

    @Override
    public double getNormValue(double value) {
        return 1.0 - value;
    }
}

