/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Statistics {
    private final List<Statistic> statistics = new ArrayList<Statistic>();
    private final Map<Statistic, Double> weights = new HashMap<Statistic, Double>();

    public void add(Statistic statistic) {
        this.statistics.add(statistic);
    }

    public void setWeight(String abbrebiation, double weight) {
        if (weight < 0.0 || weight > 1.0) {
            throw new IllegalArgumentException("Weight must be in [0, 1]: " + weight);
        }
        boolean set = false;
        for (Statistic stat : this.statistics) {
            if (!stat.getAbbreviation().equals(abbrebiation)) continue;
            this.weights.put(stat, weight);
            set = true;
        }
        if (!set) {
            throw new IllegalArgumentException("No statistic has been added with that abbreviation: " + abbrebiation);
        }
    }

    public List<Statistic> getStatistics() {
        return new ArrayList<Statistic>(this.statistics);
    }

    public double getWeight(Statistic statistic) {
        return this.weights.getOrDefault(statistic, 0.0);
    }

    public int size() {
        return this.statistics.size();
    }
}

