/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.List;

public class TrueDagPrecisionTails
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "-->-Prec";
    }

    @Override
    public String getDescription() {
        return "Proportion of X-->Y in estimated for which there is a path X~~>Y in true graph";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        int fp = 0;
        List<Node> nodes = estGraph.getNodes();
        for (Node x : nodes) {
            for (Node y : nodes) {
                Edge edge;
                if (x == y || (edge = estGraph.getEdge(x, y)) == null || !Edges.directedEdge(x, y).equals(edge)) continue;
                if (trueGraph.paths().isAncestorOf(x, y)) {
                    ++tp;
                } else {
                    ++fp;
                }
                if (!trueGraph.paths().isAncestorOf(y, x)) continue;
            }
        }
        return (double)tp / (double)(tp + fp);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

