/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.List;

public class TrueDagRecallArrows
implements Statistic {
    private static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "*->-Rec";
    }

    @Override
    public String getDescription() {
        return "Proportion of <Y, X> where there is no directed(Y, X) in the true for which and X*->Y in the estimated graph";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        int fn = 0;
        List<Node> nodes = estGraph.getNodes();
        for (Node x : nodes) {
            for (Node y : nodes) {
                Edge edge2;
                if (x == y || trueGraph.paths().isAncestorOf(y, x) || (edge2 = estGraph.getEdge(x, y)) == null) continue;
                if (edge2.getProximalEndpoint(y) == Endpoint.ARROW) {
                    ++tp;
                    continue;
                }
                ++fn;
            }
        }
        return (double)tp / (double)(tp + fn);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

