/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic.utils;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import java.util.List;

public class ArrowConfusion {
    private final boolean truthAdj;
    private int tp;
    private int tpc;
    private int fp;
    private int fpc;
    private int fn;
    private int fnc;
    private int tn;
    private int tnc;
    private int TCtp;
    private int TCfn;
    private int TCfp;

    public ArrowConfusion(Graph truth, Graph est) {
        this(truth, est, false);
    }

    public ArrowConfusion(Graph truth, Graph est, boolean truthAdj) {
        List<Edge> TwoCycle2;
        List<Edge> TwoCycle1;
        Endpoint e2True;
        Endpoint e1True;
        Edge edge2;
        List<Edge> edges2;
        Endpoint e2Est;
        Endpoint e1Est;
        Edge edge1;
        List<Edge> edges1;
        Graph truth1 = truth;
        Graph est1 = est;
        this.tp = 0;
        this.tpc = 0;
        this.fp = 0;
        this.fpc = 0;
        this.fn = 0;
        this.fnc = 0;
        this.TCtp = 0;
        this.TCfn = 0;
        this.TCfp = 0;
        this.truthAdj = truthAdj;
        est1 = GraphUtils.replaceNodes(est, truth.getNodes());
        truth1 = GraphUtils.replaceNodes(truth, est.getNodes());
        for (Edge edge : truth1.getEdges()) {
            edges1 = est1.getEdges(edge.getNode1(), edge.getNode2());
            edge1 = edges1.size() == 1 ? edges1.iterator().next() : est1.getDirectedEdge(edge.getNode1(), edge.getNode2());
            e1Est = null;
            e2Est = null;
            if (edge1 != null) {
                e1Est = edge1.getProximalEndpoint(edge.getNode1());
                e2Est = edge1.getProximalEndpoint(edge.getNode2());
            }
            edge2 = (edges2 = truth1.getEdges(edge.getNode1(), edge.getNode2())).size() == 1 ? edges2.iterator().next() : truth1.getDirectedEdge(edge.getNode1(), edge.getNode2());
            e1True = null;
            e2True = null;
            if (edge2 != null) {
                e1True = edge2.getProximalEndpoint(edge.getNode1());
                e2True = edge2.getProximalEndpoint(edge.getNode2());
            }
            if (e1True == Endpoint.ARROW && e1Est != Endpoint.ARROW) {
                ++this.fn;
            }
            if (e2True == Endpoint.ARROW && e2Est != Endpoint.ARROW) {
                ++this.fn;
            }
            if (e1True == Endpoint.ARROW && e1Est != Endpoint.ARROW && truth.isAdjacentTo(edge.getNode1(), edge.getNode2()) && est.isAdjacentTo(edge.getNode1(), edge.getNode2())) {
                this.fnc = this.getFnc() + 1;
            }
            if (e2True == Endpoint.ARROW && e2Est != Endpoint.ARROW && truth.isAdjacentTo(edge.getNode1(), edge.getNode2()) && est.isAdjacentTo(edge.getNode1(), edge.getNode2())) {
                this.fnc = this.getFnc() + 1;
            }
            if (e1True == Endpoint.ARROW && e1Est == Endpoint.ARROW) {
                ++this.tp;
            }
            if (e2True == Endpoint.ARROW && e2Est == Endpoint.ARROW) {
                ++this.tp;
            }
            if (e1True == Endpoint.ARROW && e1Est == Endpoint.ARROW && truth.isAdjacentTo(edge.getNode1(), edge.getNode2()) && est.isAdjacentTo(edge.getNode1(), edge.getNode2())) {
                this.tpc = this.getTpc() + 1;
            }
            if (e2True == Endpoint.ARROW && e2Est == Endpoint.ARROW && truth.isAdjacentTo(edge.getNode1(), edge.getNode2()) && est.isAdjacentTo(edge.getNode1(), edge.getNode2())) {
                this.tpc = this.getTpc() + 1;
            }
            if (e1True != Endpoint.ARROW && e1Est != Endpoint.ARROW) {
                ++this.tn;
            }
            if (e2True != Endpoint.ARROW && e2Est != Endpoint.ARROW) {
                ++this.tn;
            }
            if (e1True != Endpoint.ARROW && e1Est != Endpoint.ARROW && truth.isAdjacentTo(edge.getNode1(), edge.getNode2()) && est.isAdjacentTo(edge.getNode1(), edge.getNode2())) {
                this.tnc = this.getTnc() + 1;
            }
            if (e2True == Endpoint.ARROW || e2Est == Endpoint.ARROW || !truth.isAdjacentTo(edge.getNode1(), edge.getNode2()) || !est.isAdjacentTo(edge.getNode1(), edge.getNode2())) continue;
            this.tnc = this.getTnc() + 1;
        }
        for (Edge edge : est1.getEdges()) {
            edges1 = est1.getEdges(edge.getNode1(), edge.getNode2());
            edge1 = edges1.size() == 1 ? edges1.iterator().next() : est1.getDirectedEdge(edge.getNode1(), edge.getNode2());
            e1Est = null;
            e2Est = null;
            if (edge1 != null) {
                e1Est = edge1.getProximalEndpoint(edge.getNode1());
                e2Est = edge1.getProximalEndpoint(edge.getNode2());
            }
            edge2 = (edges2 = truth1.getEdges(edge.getNode1(), edge.getNode2())).size() == 1 ? edges2.iterator().next() : truth1.getDirectedEdge(edge.getNode1(), edge.getNode2());
            e1True = null;
            e2True = null;
            if (edge2 != null) {
                e1True = edge2.getProximalEndpoint(edge.getNode1());
                e2True = edge2.getProximalEndpoint(edge.getNode2());
            }
            if (this.isTruthAdj()) {
                if (truth.isAdjacentTo(edge.getNode1(), edge.getNode2())) {
                    if (e1Est == Endpoint.ARROW && e1True != Endpoint.ARROW) {
                        ++this.fp;
                    }
                    if (e2Est == Endpoint.ARROW && e2True != Endpoint.ARROW) {
                        ++this.fp;
                    }
                }
            } else {
                if (e1Est == Endpoint.ARROW && e1True != Endpoint.ARROW) {
                    ++this.fp;
                }
                if (e2Est == Endpoint.ARROW && e2True != Endpoint.ARROW) {
                    ++this.fp;
                }
            }
            if (e1Est == Endpoint.ARROW && e1True != Endpoint.ARROW && edge1 != null && edge2 != null) {
                this.fpc = this.getFpc() + 1;
            }
            if (e2Est != Endpoint.ARROW || e2True == Endpoint.ARROW || edge1 == null || edge2 == null) continue;
            this.fpc = this.getFpc() + 1;
        }
        for (Edge edge : truth1.getEdges()) {
            TwoCycle1 = truth1.getEdges(edge.getNode1(), edge.getNode2());
            TwoCycle2 = est1.getEdges(edge.getNode1(), edge.getNode2());
            if (TwoCycle1.size() == 2 && TwoCycle2.size() == 2) {
                ++this.TCtp;
            }
            if (TwoCycle1.size() != 2 || TwoCycle2.size() == 2) continue;
            ++this.TCfn;
        }
        for (Edge edge : est1.getEdges()) {
            TwoCycle1 = truth1.getEdges(edge.getNode1(), edge.getNode2());
            TwoCycle2 = est1.getEdges(edge.getNode1(), edge.getNode2());
            if (TwoCycle1.size() == 2 || TwoCycle2.size() != 2) continue;
            ++this.TCfp;
        }
        this.TCtp /= 2;
        this.TCfn /= 2;
        this.TCfp /= 2;
    }

    public int getTp() {
        return this.tp;
    }

    public int getFp() {
        return this.fp;
    }

    public int getFn() {
        return this.fn;
    }

    public int getTn() {
        return this.tn;
    }

    public int getTwoCycleTp() {
        return this.TCtp;
    }

    public int getTwoCycleFp() {
        return this.TCfp;
    }

    public int getTwoCycleFn() {
        return this.TCfn;
    }

    public int getTpc() {
        return this.tpc;
    }

    public int getFpc() {
        return this.fpc;
    }

    public int getFnc() {
        return this.fnc;
    }

    public int getTnc() {
        return this.tnc;
    }

    public boolean isTruthAdj() {
        return this.truthAdj;
    }
}

