/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic.utils;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;

public class OrientationConfusion {
    private int tp = 0;
    private int fp = 0;
    private int fn = 0;
    private int tn = 0;

    public OrientationConfusion(Graph truth, Graph est) {
        Node b;
        Node a;
        for (Edge edge : truth.getEdges()) {
            boolean m2;
            if (!edge.isDirected()) continue;
            a = edge.getNode1();
            if (!est.isAdjacentTo(a, b = edge.getNode2())) {
                ++this.fn;
                continue;
            }
            Edge other = est.getEdge(a, b);
            boolean m1 = edge.getEndpoint1() == other.getProximalEndpoint(a);
            boolean bl = m2 = edge.getEndpoint2() == other.getProximalEndpoint(b);
            if (m1 && m2) {
                ++this.tp;
                ++this.tn;
                continue;
            }
            if (!m1 && !m2) {
                ++this.fp;
                ++this.fn;
                continue;
            }
            if (other.getEndpoint1() != Endpoint.TAIL || other.getEndpoint2() != Endpoint.TAIL) continue;
            ++this.fn;
        }
        for (Edge edge : est.getEdges()) {
            if (!edge.isDirected() || truth.isAdjacentTo(a = edge.getNode1(), b = edge.getNode2())) continue;
            ++this.fp;
        }
    }

    public int getTp() {
        return this.tp;
    }

    public int getFp() {
        return this.fp;
    }

    public int getFn() {
        return this.fn;
    }

    public int getTn() {
        return this.tn;
    }
}

