/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.annotation;

import edu.cmu.tetrad.annotation.AnnotatedClass;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public abstract class AbstractAnnotations<T extends Annotation> {
    protected final List<AnnotatedClass<T>> annotatedClasses;

    public AbstractAnnotations(String packageName, Class<T> type) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set<Class<?>> classes = reflections.getTypesAnnotatedWith(type);
        this.annotatedClasses = classes.parallelStream().map(e -> new AnnotatedClass((Class)e, e.getAnnotation(type))).collect(Collectors.toList());
    }

    public List<AnnotatedClass<T>> getAnnotatedClasses() {
        return Collections.unmodifiableList(this.annotatedClasses);
    }

    public List<AnnotatedClass<T>> filterByAnnotation(List<AnnotatedClass<T>> annoClasses, Class<? extends Annotation> type) {
        if (annoClasses == null || type == null) {
            return Collections.EMPTY_LIST;
        }
        List list = annoClasses.stream().filter(e -> e.getClazz().isAnnotationPresent(type)).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    public List<AnnotatedClass<T>> filterOutByAnnotation(List<AnnotatedClass<T>> annoClasses, Class<? extends Annotation> type) {
        if (annoClasses == null || type == null) {
            return Collections.EMPTY_LIST;
        }
        List list = annoClasses.stream().filter(e -> !e.getClazz().isAnnotationPresent(type)).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }
}

