/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.graph.Graph;
import org.apache.commons.math3.util.FastMath;

final class BayesImDistanceFunction {
    BayesImDistanceFunction() {
    }

    public static double distance(BayesIm firstBn, BayesIm secondBn) {
        if (!firstBn.getBayesPm().equals(secondBn.getBayesPm())) {
            throw new IllegalArgumentException("BayesPms must be equal.");
        }
        Graph graph = firstBn.getBayesPm().getDag();
        int numNodes = graph.getNumNodes();
        double sum = 0.0;
        for (int i = 0; i < numNodes; ++i) {
            int numRows = firstBn.getNumRows(i);
            for (int j = 0; j < numRows; ++j) {
                int numCols = firstBn.getNumColumns(i);
                for (int k = 0; k < numCols; ++k) {
                    double diff = firstBn.getProbability(i, j, k) - secondBn.getProbability(i, j, k);
                    sum += diff * diff;
                }
            }
        }
        return FastMath.sqrt(sum);
    }
}

