/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.DiscreteProbs;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class BayesImProbs
implements DiscreteProbs,
TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final BayesIm bayesIm;
    private final List<Node> variables;

    public BayesImProbs(BayesIm bayesIm) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        this.bayesIm = bayesIm;
        LinkedList<DiscreteVariable> variables = new LinkedList<DiscreteVariable>();
        BayesPm bayesPm = bayesIm.getBayesPm();
        for (int i = 0; i < bayesIm.getNumNodes(); ++i) {
            Node node = bayesIm.getNode(i);
            String name = node.getName();
            int numCategories = bayesPm.getNumCategories(node);
            LinkedList<String> categories = new LinkedList<String>();
            for (int j = 0; j < numCategories; ++j) {
                categories.add(bayesPm.getCategory(node, j));
            }
            variables.add(new DiscreteVariable(name, categories));
        }
        this.variables = Collections.unmodifiableList(variables);
    }

    public static BayesImProbs serializableInstance() {
        return new BayesImProbs(MlBayesIm.serializableInstance());
    }

    private static boolean hasNextValue(Proposition proposition, int variable, int currentIndex) {
        return BayesImProbs.nextValue(proposition, variable, currentIndex) != -1;
    }

    private static int nextValue(Proposition proposition, int variable, int currentIndex) {
        for (int i = currentIndex + 1; i < proposition.getNumCategories(variable); ++i) {
            if (!proposition.isAllowed(variable, i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double getCellProb(int[] variableValues) {
        double p = 1.0;
        block0: for (int node = 0; node < variableValues.length; ++node) {
            int[] parents = this.bayesIm.getParents(node);
            int[] parentValues = new int[parents.length];
            for (int parentIndex = 0; parentIndex < parentValues.length; ++parentIndex) {
                parentValues[parentIndex] = variableValues[parents[parentIndex]];
                if (parentValues[parentIndex] == -99) continue block0;
            }
            int rowIndex = this.bayesIm.getRowIndex(node, parentValues);
            int colIndex = variableValues[node];
            if (colIndex == -99) continue;
            p *= this.bayesIm.getProbability(node, rowIndex, colIndex);
        }
        return p;
    }

    @Override
    public double getProb(Proposition assertion) {
        int[] variableValues = new int[assertion.getNumVariables()];
        for (int i = 0; i < assertion.getNumVariables(); ++i) {
            variableValues[i] = BayesImProbs.nextValue(assertion, i, -1);
        }
        variableValues[variableValues.length - 1] = -1;
        double p = 0.0;
        block1: while (true) {
            for (int i = assertion.getNumVariables() - 1; i >= 0; --i) {
                if (!BayesImProbs.hasNextValue(assertion, i, variableValues[i])) continue;
                variableValues[i] = BayesImProbs.nextValue(assertion, i, variableValues[i]);
                for (int j = i + 1; j < assertion.getNumVariables(); ++j) {
                    if (!BayesImProbs.hasNextValue(assertion, j, -1)) break block1;
                    variableValues[j] = BayesImProbs.nextValue(assertion, j, -1);
                }
                double cellProb = this.getCellProb(variableValues);
                if (Double.isNaN(cellProb)) continue;
                p += cellProb;
            }
            break;
        }
        return p;
    }

    @Override
    public double getConditionalProb(Proposition assertion, Proposition condition) {
        if (assertion.getVariableSource() != condition.getVariableSource()) {
            throw new IllegalArgumentException("Assertion and condition must be for the same Bayes IM.");
        }
        int[] variableValues = new int[condition.getNumVariables()];
        for (int i = 0; i < condition.getNumVariables(); ++i) {
            variableValues[i] = BayesImProbs.nextValue(condition, i, -1);
        }
        variableValues[variableValues.length - 1] = -1;
        double conditionTrue = 0.0;
        double assertionTrue = 0.0;
        block1: while (true) {
            for (int i = condition.getNumVariables() - 1; i >= 0; --i) {
                if (!BayesImProbs.hasNextValue(condition, i, variableValues[i])) continue;
                variableValues[i] = BayesImProbs.nextValue(condition, i, variableValues[i]);
                for (int j = i + 1; j < condition.getNumVariables(); ++j) {
                    if (!BayesImProbs.hasNextValue(condition, j, -1)) break block1;
                    variableValues[j] = BayesImProbs.nextValue(condition, j, -1);
                }
                double cellProb = this.getCellProb(variableValues);
                if (Double.isNaN(cellProb)) continue;
                boolean assertionHolds = true;
                for (int j = 0; j < assertion.getNumVariables(); ++j) {
                    if (assertion.isAllowed(j, variableValues[j])) continue;
                    assertionHolds = false;
                    break;
                }
                if (assertionHolds) {
                    assertionTrue += cellProb;
                }
                conditionTrue += cellProb;
            }
            break;
        }
        return assertionTrue / conditionTrue;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesIm == null) {
            throw new NullPointerException();
        }
        if (this.variables == null) {
            throw new NullPointerException();
        }
    }
}

