/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesEstimator;
import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataBox;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.VerticalIntDataBox;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.DiscreteBicScore;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.util.FastMath;

public final class BayesProperties {
    private final DataSet dataSet;
    private final List<Node> variables;
    private final int[][] data;
    private final int sampleSize;
    private final int[] numCategories;
    private double chisq;
    private double dof;
    private double bic;
    private double likelihood;

    public BayesProperties(DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.dataSet = dataSet;
        if (dataSet instanceof BoxDataSet) {
            DataBox dataBox = ((BoxDataSet)dataSet).getDataBox();
            this.variables = dataSet.getVariables();
            VerticalIntDataBox box = new VerticalIntDataBox(dataBox);
            this.data = box.getVariableVectors();
        } else {
            this.data = new int[dataSet.getNumColumns()][];
            this.variables = dataSet.getVariables();
            for (int j = 0; j < dataSet.getNumColumns(); ++j) {
                this.data[j] = new int[dataSet.getNumRows()];
                for (int i = 0; i < dataSet.getNumRows(); ++i) {
                    this.data[j][i] = dataSet.getInt(i, j);
                }
            }
        }
        this.sampleSize = dataSet.getNumRows();
        List<Node> variables = dataSet.getVariables();
        this.numCategories = new int[variables.size()];
        for (int i = 0; i < variables.size(); ++i) {
            DiscreteVariable variable = this.getVariable(i);
            if (variable == null) continue;
            this.numCategories[i] = variable.getNumCategories();
        }
    }

    private static int getRowIndex(int[] dim, int[] values) {
        int rowIndex = 0;
        for (int i = 0; i < dim.length; ++i) {
            rowIndex *= dim[i];
            rowIndex += values[i];
        }
        return rowIndex;
    }

    public LikelihoodRet getLikelihoodRatioP(Graph graph) {
        double chisq;
        List<Node> nodes = graph.getNodes();
        EdgeListGraph graph0 = new EdgeListGraph(nodes);
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                graph0.addDirectedEdge(nodes.get(i), nodes.get(j));
            }
        }
        Ret r0 = this.getLikelihood2(graph0);
        Ret r1 = this.getLikelihood2(graph);
        this.likelihood = r1.getLik();
        double lDiff = r0.getLik() - r1.getLik();
        System.out.println("lDiff = " + lDiff);
        int nDiff = r0.getDof() - r1.getDof();
        System.out.println("nDiff = " + nDiff);
        this.chisq = chisq = 2.0 * lDiff;
        this.dof = nDiff;
        int N = this.dataSet.getNumRows();
        this.bic = 2.0 * r1.getLik() - (double)r1.getDof() * FastMath.log(N);
        System.out.println("bic = " + this.bic);
        System.out.println("chisq = " + chisq);
        System.out.println("dof = " + (double)nDiff);
        double p = 1.0 - new ChiSquaredDistribution(nDiff).cumulativeProbability(chisq);
        System.out.println("p = " + p);
        LikelihoodRet _ret = new LikelihoodRet();
        _ret.p = p;
        _ret.bic = this.bic;
        _ret.chiSq = chisq;
        _ret.dof = this.dof;
        return _ret;
    }

    public double getChisq() {
        return this.chisq;
    }

    public double getDof() {
        return this.dof;
    }

    public double getBic() {
        return this.bic;
    }

    public double getLikelihood() {
        return this.likelihood;
    }

    private int getDof(Graph graph) {
        graph = GraphUtils.replaceNodes(graph, this.dataSet.getVariables());
        BayesPm pm = new BayesPm(graph);
        BayesIm im = new MlBayesEstimator().estimate(pm, this.dataSet);
        int numParams = 0;
        for (int j = 0; j < im.getNumNodes(); ++j) {
            int numColumns = im.getNumColumns(j);
            int numRows = im.getNumRows(j);
            numParams += (numColumns - 1) * numRows;
        }
        return numParams;
    }

    private double getLikelihood(Graph graph) {
        graph = GraphUtils.replaceNodes(graph, this.dataSet.getVariables());
        BayesPm pm = new BayesPm(graph);
        BayesIm im = new MlBayesEstimator().estimate(pm, this.dataSet);
        double lik = 0.0;
        block0: for (int i = 0; i < this.dataSet.getNumRows(); ++i) {
            double lik0 = 0.0;
            for (int j = 0; j < this.dataSet.getNumColumns(); ++j) {
                int[] parents = im.getParents(j);
                int[] parentValues = new int[parents.length];
                for (int k = 0; k < parents.length; ++k) {
                    parentValues[k] = this.dataSet.getInt(i, parents[k]);
                }
                int dataValue = this.dataSet.getInt(i, j);
                double p = im.getProbability(j, im.getRowIndex(j, parentValues), dataValue);
                if (p == 0.0) continue block0;
                lik0 += FastMath.log(p);
            }
            lik += lik0;
        }
        return lik;
    }

    private Ret getLikelihood2(Graph graph) {
        double lik = 0.0;
        int dof = 0;
        for (Node node : graph.getNodes()) {
            ArrayList<Node> parents = new ArrayList<Node>(graph.getParents(node));
            int i = this.variables.indexOf(this.getVariable(node.getName()));
            int[] z = new int[parents.size()];
            for (int j = 0; j < parents.size(); ++j) {
                z[j] = this.variables.indexOf(this.getVariable(((Node)parents.get(j)).getName()));
            }
            Ret ret = this.getLikelihoodNode(i, z);
            lik += ret.getLik();
            dof += ret.getDof();
        }
        return new Ret(lik, dof);
    }

    private int getDof2(Graph graph) {
        int dof = 0;
        for (Node node : graph.getNodes()) {
            ArrayList<Node> parents = new ArrayList<Node>(graph.getParents(node));
            int i = this.variables.indexOf(this.getVariable(node.getName()));
            int[] z = new int[parents.size()];
            for (int j = 0; j < parents.size(); ++j) {
                z[j] = this.variables.indexOf(this.getVariable(((Node)parents.get(j)).getName()));
            }
            dof = (int)((double)dof + this.getDofNode(i, z));
        }
        return dof;
    }

    private Ret getLikelihoodNode(int node, int[] parents) {
        DiscreteBicScore bic = new DiscreteBicScore(this.dataSet);
        double lik = bic.localScore(node, parents);
        int dof = (this.numCategories[node] - 1) * parents.length;
        return new Ret(lik, dof);
    }

    private double getDofNode(int node, int[] parents) {
        int c = this.numCategories[node];
        int[] dims = new int[parents.length];
        for (int p = 0; p < parents.length; ++p) {
            dims[p] = this.numCategories[parents[p]];
        }
        int r = 1;
        for (int p = 0; p < parents.length; ++p) {
            r *= dims[p];
        }
        return r * c;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public Node getVariable(String targetName) {
        for (Node node : this.variables) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    private DiscreteVariable getVariable(int i) {
        if (this.variables.get(i) instanceof DiscreteVariable) {
            return (DiscreteVariable)this.variables.get(i);
        }
        return null;
    }

    private static class Ret {
        private final double lik;
        private final int dof;

        public Ret(double lik, int dof) {
            this.lik = lik;
            this.dof = dof;
        }

        public double getLik() {
            return this.lik;
        }

        public int getDof() {
            return this.dof;
        }
    }

    public class LikelihoodRet {
        public double p;
        public double bic;
        public double chiSq;
        public double dof;
    }
}

