/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import java.util.List;

final class BayesUtils {
    BayesUtils() {
    }

    public static void ensureVarsInData(List<Node> pmVars, DataSet dataSet) {
        for (Node pmVar1 : pmVars) {
            List<String> dataCategories;
            DiscreteVariable pmVar = (DiscreteVariable)pmVar1;
            String name = pmVar.getName();
            DiscreteVariable from = (DiscreteVariable)dataSet.getVariable(name);
            if (from == null) {
                throw new IllegalArgumentException("Variable " + pmVar + " was not in the data.");
            }
            List<String> pmCategories = pmVar.getCategories();
            if (pmCategories.equals(dataCategories = from.getCategories())) continue;
            if (pmCategories.containsAll(dataCategories)) {
                DiscreteVariable to = new DiscreteVariable(pmVar);
                dataSet.changeVariable(from, to);
                continue;
            }
            throw new IllegalArgumentException("Variable '" + name + "' has more categories in the data than in the model.\n\tIn the model, the categories are: " + pmCategories + ".\n\tIn the data, the categories are: " + dataCategories + ".");
        }
    }
}

