/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.DiscreteProbs;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import java.util.List;

public final class CellTableProbs
implements DiscreteProbs {
    private final DataSet dataSet;
    private final int[] dims;
    private final int[] cells;
    private int numPoints;

    public CellTableProbs(DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException("Data set not provided.");
        }
        this.dataSet = dataSet;
        this.dims = new int[dataSet.getNumColumns()];
        for (int i = 0; i < this.dims.length; ++i) {
            DiscreteVariable variable = (DiscreteVariable)dataSet.getVariable(i);
            this.dims[i] = variable.getNumCategories();
        }
        int size = 1;
        for (Object dim : (DiscreteVariable)this.dims) {
            size *= dim;
        }
        this.cells = new int[size];
        int numRows = dataSet.getNumRows();
        int[] point = new int[this.dims.length];
        boolean missingValueCaseFound = false;
        block2: for (int i = 0; i < numRows; ++i) {
            int cellIndex;
            for (int j = 0; j < this.dims.length; ++j) {
                point[j] = dataSet.getInt(i, j);
                if (point[j] != -99) continue;
                missingValueCaseFound = true;
                continue block2;
            }
            int n = cellIndex = this.getCellIndex(point);
            this.cells[n] = this.cells[n] + 1;
            ++this.numPoints;
        }
    }

    private static boolean hasNextValue(Proposition proposition, int variable, int curIndex) {
        return CellTableProbs.nextValue(proposition, variable, curIndex) != -1;
    }

    private static int nextValue(Proposition proposition, int variable, int curIndex) {
        for (int i = curIndex + 1; i < proposition.getNumCategories(variable); ++i) {
            if (!proposition.isAllowed(variable, i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double getCellProb(int[] variableValues) {
        int cellIndex = this.getCellIndex(variableValues);
        int cellCount = this.cells[cellIndex];
        return (double)cellCount / (double)this.numPoints;
    }

    @Override
    public double getProb(Proposition assertion) {
        int[] variableValues = new int[assertion.getNumVariables()];
        for (int i = 0; i < assertion.getNumVariables(); ++i) {
            variableValues[i] = CellTableProbs.nextValue(assertion, i, -1);
        }
        variableValues[variableValues.length - 1] = -1;
        double p = 0.0;
        block1: while (true) {
            for (int i = assertion.getNumVariables() - 1; i >= 0; --i) {
                if (!CellTableProbs.hasNextValue(assertion, i, variableValues[i])) continue;
                variableValues[i] = CellTableProbs.nextValue(assertion, i, variableValues[i]);
                for (int j = i + 1; j < assertion.getNumVariables(); ++j) {
                    if (!CellTableProbs.hasNextValue(assertion, j, -1)) break block1;
                    variableValues[j] = CellTableProbs.nextValue(assertion, j, -1);
                }
                p += this.getCellProb(variableValues);
            }
            break;
        }
        return p;
    }

    @Override
    public double getConditionalProb(Proposition assertion, Proposition condition) {
        List<Node> dataVars;
        if (assertion.getVariableSource() != condition.getVariableSource()) {
            throw new IllegalArgumentException("Assertion and condition must be for the same Bayes IM.");
        }
        List<Node> assertionVars = assertion.getVariableSource().getVariables();
        if (!assertionVars.equals(dataVars = this.dataSet.getVariables())) {
            throw new IllegalArgumentException("Assertion variable and data variables are either different or in a different order: \n\tAssertion vars: " + assertionVars + "\n\tData vars: " + dataVars);
        }
        int[] variableValues = new int[condition.getNumVariables()];
        for (int i = 0; i < condition.getNumVariables(); ++i) {
            variableValues[i] = CellTableProbs.nextValue(condition, i, -1);
        }
        variableValues[variableValues.length - 1] = -1;
        double conditionTrue = 0.0;
        double assertionTrue = 0.0;
        block1: while (true) {
            for (int i = condition.getNumVariables() - 1; i >= 0; --i) {
                if (!CellTableProbs.hasNextValue(condition, i, variableValues[i])) continue;
                variableValues[i] = CellTableProbs.nextValue(condition, i, variableValues[i]);
                for (int j = i + 1; j < condition.getNumVariables(); ++j) {
                    if (!CellTableProbs.hasNextValue(condition, j, -1)) break block1;
                    variableValues[j] = CellTableProbs.nextValue(condition, j, -1);
                }
                double cellProb = this.getCellProb(variableValues);
                boolean assertionHolds = true;
                for (int j = 0; j < assertion.getNumVariables(); ++j) {
                    if (assertion.isAllowed(j, variableValues[j])) continue;
                    assertionHolds = false;
                    break;
                }
                if (assertionHolds) {
                    assertionTrue += cellProb;
                }
                conditionTrue += cellProb;
            }
            break;
        }
        return assertionTrue / conditionTrue;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public List<Node> getVariables() {
        return null;
    }

    private boolean isBoundsEnforced() {
        return true;
    }

    private int getCellIndex(int[] coords) {
        int i;
        int cellIndex = 0;
        if (this.isBoundsEnforced()) {
            if (coords.length != this.dims.length) {
                throw new IllegalArgumentException("Coordinate array must have the proper number of dimensions.");
            }
            for (i = 0; i < coords.length; ++i) {
                if (coords[i] >= 0 && coords[i] < this.dims[i]) continue;
                throw new IllegalArgumentException("Coordinate #" + i + " for variable " + this.dataSet.getVariable(i) + " is out of bounds [0, " + (this.dims[i] - 1) + "]: " + coords[i]);
            }
        }
        for (i = 0; i < this.dims.length; ++i) {
            cellIndex *= this.dims[i];
            if ((cellIndex += coords[i]) != Integer.MAX_VALUE && cellIndex >= 0) continue;
            throw new ArrayIndexOutOfBoundsException("Cannot construct a cell table with that many cells.");
        }
        return cellIndex;
    }
}

