/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.CptInvariantMarginalCalculator;
import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.ManipulatingBayesUpdater;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.UpdatedBayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public final class CptInvariantUpdater
implements ManipulatingBayesUpdater {
    private static final long serialVersionUID = 23L;
    private final BayesIm bayesIm;
    private BayesIm manipulatedBayesIm;
    private UpdatedBayesIm updatedBayesIm;
    private Evidence evidence;
    private CptInvariantMarginalCalculator cptInvariantMarginalCalculator;

    public CptInvariantUpdater(BayesIm bayesIm) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        this.bayesIm = bayesIm;
        this.setEvidence(Evidence.tautology(this.bayesIm));
    }

    public CptInvariantUpdater(BayesIm bayesIm, Evidence evidence) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        this.bayesIm = bayesIm;
        this.setEvidence(evidence);
    }

    public static CptInvariantUpdater serializableInstance() {
        return new CptInvariantUpdater(MlBayesIm.serializableInstance());
    }

    @Override
    public BayesIm getBayesIm() {
        return this.bayesIm;
    }

    @Override
    public BayesIm getManipulatedBayesIm() {
        return this.manipulatedBayesIm;
    }

    @Override
    public Graph getManipulatedGraph() {
        return this.getManipulatedBayesIm().getDag();
    }

    @Override
    public BayesIm getUpdatedBayesIm() {
        return this.updatedBayesIm;
    }

    @Override
    public Evidence getEvidence() {
        return new Evidence(this.evidence);
    }

    @Override
    public void setEvidence(Evidence evidence) {
        if (evidence == null) {
            throw new NullPointerException();
        }
        if (evidence.isIncompatibleWith(this.bayesIm)) {
            throw new IllegalArgumentException("The variable list for this evidence must be compatible with the variable list of the stored IM.");
        }
        this.evidence = evidence;
        Graph graph = this.bayesIm.getBayesPm().getDag();
        Dag manipulatedGraph = this.createManipulatedGraph(graph);
        BayesPm manipulatedBayesPm = this.createManipulatedBayesPm(manipulatedGraph);
        this.manipulatedBayesIm = this.createdManipulatedBayesIm(manipulatedBayesPm);
        Evidence evidence2 = new Evidence(evidence, this.manipulatedBayesIm);
        this.updatedBayesIm = new UpdatedBayesIm(this.manipulatedBayesIm, evidence2);
        this.cptInvariantMarginalCalculator = new CptInvariantMarginalCalculator(this.bayesIm, evidence2);
    }

    @Override
    public double getMarginal(int variable, int value) {
        return this.cptInvariantMarginalCalculator.getMarginal(variable, value);
    }

    @Override
    public boolean isJointMarginalSupported() {
        return false;
    }

    @Override
    public double getJointMarginal(int[] variables, int[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] calculatePriorMarginals(int nodeIndex) {
        Evidence evidence = this.getEvidence();
        this.setEvidence(Evidence.tautology(evidence.getVariableSource()));
        double[] marginals = new double[evidence.getNumCategories(nodeIndex)];
        for (int i = 0; i < this.getBayesIm().getNumColumns(nodeIndex); ++i) {
            marginals[i] = this.getMarginal(nodeIndex, i);
        }
        this.setEvidence(evidence);
        return marginals;
    }

    @Override
    public double[] calculateUpdatedMarginals(int nodeIndex) {
        double[] marginals = new double[this.evidence.getNumCategories(nodeIndex)];
        for (int i = 0; i < this.getBayesIm().getNumColumns(nodeIndex); ++i) {
            marginals[i] = this.getMarginal(nodeIndex, i);
        }
        return marginals;
    }

    public String toString() {
        return "CPT Invariant Updater, evidence = " + this.evidence;
    }

    private BayesIm createdManipulatedBayesIm(BayesPm updatedBayesPm) {
        return new MlBayesIm(updatedBayesPm, this.bayesIm, 0);
    }

    private BayesPm createManipulatedBayesPm(Dag updatedGraph) {
        return new BayesPm(updatedGraph, this.bayesIm.getBayesPm());
    }

    private Dag createManipulatedGraph(Graph graph) {
        Dag updatedGraph = new Dag(graph);
        for (int i = 0; i < this.evidence.getNumNodes(); ++i) {
            if (!this.evidence.isManipulated(i)) continue;
            Node node = updatedGraph.getNode(this.evidence.getNode(i).getName());
            List<Node> parents = updatedGraph.getParents(node);
            for (Node parent1 : parents) {
                updatedGraph.removeEdge(node, parent1);
            }
        }
        return updatedGraph;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesIm == null) {
            throw new NullPointerException();
        }
        if (this.evidence == null) {
            throw new NullPointerException();
        }
    }
}

