/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;

public final class Manipulation
implements TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final VariableSource variableSource;
    private final boolean[] manipulated;

    public Manipulation(VariableSource variableSource) {
        if (variableSource == null) {
            throw new NullPointerException();
        }
        this.variableSource = variableSource;
        this.manipulated = new boolean[this.getNumNodes()];
    }

    public Manipulation(Manipulation manipulation) {
        if (manipulation == null) {
            throw new NullPointerException();
        }
        if (manipulation.getVariableSource() == null) {
            throw new NullPointerException("Please reconstruct this part of the session; there was an error.");
        }
        this.variableSource = manipulation.getVariableSource();
        this.manipulated = new boolean[this.getNumNodes()];
        for (int i = 0; i < this.manipulated.length; ++i) {
            this.manipulated[i] = manipulation.isManipulated(i);
        }
    }

    public static Manipulation serializableInstance() {
        return new Manipulation(MlBayesIm.serializableInstance());
    }

    public void setManipulated(int nodeIndex, boolean manipulated) {
        this.manipulated[nodeIndex] = manipulated;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nManipulation:");
        buf.append("\n");
        for (int i = 0; i < this.getNumNodes(); ++i) {
            buf.append(this.isManipulated(i) ? "(Man)" : "     ");
            buf.append("\t");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Manipulation)) {
            return false;
        }
        Manipulation evidence = (Manipulation)o;
        if (this.getVariableSource() != evidence.getVariableSource()) {
            return false;
        }
        for (int i = 0; i < this.manipulated.length; ++i) {
            if (this.manipulated[i] == evidence.manipulated[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 37;
        hashCode = 19 * hashCode + this.getVariableSource().hashCode();
        hashCode = 19 * hashCode + Arrays.hashCode(this.manipulated);
        return hashCode;
    }

    private int getNumNodes() {
        return this.getVariableSource().getVariables().size();
    }

    public boolean isManipulated(int nodeIndex) {
        return this.manipulated[nodeIndex];
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    private VariableSource getVariableSource() {
        return this.variableSource;
    }
}

