/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.VerticalIntDataBox;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.util.FastMath;

public final class MlBayesIm
implements BayesIm {
    public static final int MANUAL = 0;
    public static final int RANDOM = 1;
    private static final long serialVersionUID = 23L;
    private static final double ALLOWABLE_DIFFERENCE = 0.001;
    private final BayesPm bayesPm;
    private final Node[] nodes;
    private int[][] parents;
    private int[][] parentDims;
    private double[][][] probs;

    public MlBayesIm(BayesPm bayesPm) throws IllegalArgumentException {
        this(bayesPm, null, 0);
    }

    public MlBayesIm(BayesPm bayesPm, int initializationMethod) throws IllegalArgumentException {
        this(bayesPm, null, initializationMethod);
    }

    public MlBayesIm(BayesPm bayesPm, BayesIm oldBayesIm, int initializationMethod) throws IllegalArgumentException {
        if (bayesPm == null) {
            throw new NullPointerException("BayesPm must not be null.");
        }
        this.bayesPm = new BayesPm(bayesPm);
        Graph graph = bayesPm.getDag();
        this.nodes = graph.getNodes().toArray(new Node[0]);
        this.initialize(oldBayesIm, initializationMethod);
    }

    public MlBayesIm(BayesIm bayesIm) throws IllegalArgumentException {
        if (bayesIm == null) {
            throw new NullPointerException("BayesIm must not be null.");
        }
        this.bayesPm = bayesIm.getBayesPm();
        this.nodes = new Node[bayesIm.getNumNodes()];
        for (int i = 0; i < bayesIm.getNumNodes(); ++i) {
            this.nodes[i] = bayesIm.getNode(i);
        }
        this.initialize(bayesIm, 0);
    }

    public static MlBayesIm serializableInstance() {
        return new MlBayesIm(BayesPm.serializableInstance());
    }

    public static List<String> getParameterNames() {
        return new ArrayList<String>();
    }

    private static double[] getRandomWeights2(int size, double[] biases) {
        int i;
        assert (size >= 0);
        double[] row = new double[size];
        double sum = 0.0;
        for (i = 0; i < size; ++i) {
            double v = RandomUtil.getInstance().nextUniform(0.0, biases[i]);
            row[i] = v > 0.5 ? 2.0 * v : v;
            sum += row[i];
        }
        i = 0;
        while (i < size) {
            int n = i++;
            row[n] = row[n] / sum;
        }
        return row;
    }

    private static double[] getRandomWeights3(int size) {
        int i;
        assert (size >= 0);
        double[] row = new double[size];
        double sum = 0.0;
        for (i = 0; i < size; ++i) {
            row[i] = RandomUtil.getInstance().nextBeta((double)size / 4.0, size);
            sum += row[i];
        }
        i = 0;
        while (i < size) {
            int n = i++;
            row[n] = row[n] / sum;
        }
        return row;
    }

    private static double[] getRandomWeights(int size) {
        int i;
        assert (size >= 0);
        double[] row = new double[size];
        double sum = 0.0;
        double bias = 0.0;
        for (i = 0; i < size; ++i) {
            row[i] = RandomUtil.getInstance().nextDouble();
            if (row[i] > 0.5) {
                int n = i;
                row[n] = row[n] + 0.0;
            }
            sum += row[i];
        }
        i = 0;
        while (i < size) {
            int n = i++;
            row[n] = row[n] / sum;
        }
        return row;
    }

    @Override
    public BayesPm getBayesPm() {
        return this.bayesPm;
    }

    @Override
    public Graph getDag() {
        return this.bayesPm.getDag();
    }

    @Override
    public int getNumNodes() {
        return this.nodes.length;
    }

    @Override
    public Node getNode(int nodeIndex) {
        return this.nodes[nodeIndex];
    }

    @Override
    public Node getNode(String name) {
        return this.getDag().getNode(name);
    }

    @Override
    public int getNodeIndex(Node node) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (node != this.nodes[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Node> getVariables() {
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int i = 0; i < this.getNumNodes(); ++i) {
            Node node = this.getNode(i);
            variables.add(this.bayesPm.getVariable(node));
        }
        return variables;
    }

    @Override
    public List<Node> getMeasuredNodes() {
        return this.bayesPm.getMeasuredNodes();
    }

    @Override
    public List<String> getVariableNames() {
        LinkedList<String> variableNames = new LinkedList<String>();
        for (int i = 0; i < this.getNumNodes(); ++i) {
            Node node = this.getNode(i);
            variableNames.add(this.bayesPm.getVariable(node).getName());
        }
        return variableNames;
    }

    @Override
    public int getNumColumns(int nodeIndex) {
        return this.probs[nodeIndex][0].length;
    }

    @Override
    public int getNumRows(int nodeIndex) {
        return this.probs[nodeIndex].length;
    }

    @Override
    public int getNumParents(int nodeIndex) {
        return this.parents[nodeIndex].length;
    }

    @Override
    public int getParent(int nodeIndex, int parentIndex) {
        return this.parents[nodeIndex][parentIndex];
    }

    @Override
    public int getParentDim(int nodeIndex, int parentIndex) {
        return this.parentDims[nodeIndex][parentIndex];
    }

    @Override
    public int[] getParentDims(int nodeIndex) {
        int[] dims = this.parentDims[nodeIndex];
        int[] copy = new int[dims.length];
        System.arraycopy(dims, 0, copy, 0, dims.length);
        return copy;
    }

    @Override
    public int[] getParents(int nodeIndex) {
        int[] nodeParents = this.parents[nodeIndex];
        int[] copy = new int[nodeParents.length];
        System.arraycopy(nodeParents, 0, copy, 0, nodeParents.length);
        return copy;
    }

    @Override
    public int[] getParentValues(int nodeIndex, int rowIndex) {
        int[] dims = this.getParentDims(nodeIndex);
        int[] values = new int[dims.length];
        for (int i = dims.length - 1; i >= 0; --i) {
            values[i] = rowIndex % dims[i];
            rowIndex /= dims[i];
        }
        return values;
    }

    @Override
    public int getParentValue(int nodeIndex, int rowIndex, int colIndex) {
        return this.getParentValues(nodeIndex, rowIndex)[colIndex];
    }

    @Override
    public double getProbability(int nodeIndex, int rowIndex, int colIndex) {
        return this.probs[nodeIndex][rowIndex][colIndex];
    }

    @Override
    public int getRowIndex(int nodeIndex, int[] values) {
        int[] dim = this.getParentDims(nodeIndex);
        int rowIndex = 0;
        for (int i = 0; i < dim.length; ++i) {
            rowIndex *= dim[i];
            rowIndex += values[i];
        }
        return rowIndex;
    }

    @Override
    public void normalizeAll() {
        for (int nodeIndex = 0; nodeIndex < this.nodes.length; ++nodeIndex) {
            this.normalizeNode(nodeIndex);
        }
    }

    @Override
    public void normalizeNode(int nodeIndex) {
        for (int rowIndex = 0; rowIndex < this.getNumRows(nodeIndex); ++rowIndex) {
            this.normalizeRow(nodeIndex, rowIndex);
        }
    }

    @Override
    public void normalizeRow(int nodeIndex, int rowIndex) {
        int colIndex;
        int numColumns = this.getNumColumns(nodeIndex);
        double total = 0.0;
        for (colIndex = 0; colIndex < numColumns; ++colIndex) {
            total += this.getProbability(nodeIndex, rowIndex, colIndex);
        }
        if (total != 0.0) {
            for (colIndex = 0; colIndex < numColumns; ++colIndex) {
                double probability = this.getProbability(nodeIndex, rowIndex, colIndex);
                double prob = probability / total;
                this.setProbability(nodeIndex, rowIndex, colIndex, prob);
            }
        } else {
            double prob = 1.0 / (double)numColumns;
            for (int colIndex2 = 0; colIndex2 < numColumns; ++colIndex2) {
                this.setProbability(nodeIndex, rowIndex, colIndex2, prob);
            }
        }
    }

    @Override
    public void setProbability(int nodeIndex, double[][] probMatrix) {
        for (int i = 0; i < probMatrix.length; ++i) {
            System.arraycopy(probMatrix[i], 0, this.probs[nodeIndex][i], 0, probMatrix[i].length);
        }
    }

    @Override
    public void setProbability(int nodeIndex, int rowIndex, int colIndex, double value) {
        if (colIndex >= this.getNumColumns(nodeIndex)) {
            throw new IllegalArgumentException("Column out of range: " + colIndex + " >= " + this.getNumColumns(nodeIndex));
        }
        if (!(0.0 <= value && value <= 1.0 || Double.isNaN(value))) {
            throw new IllegalArgumentException("Probability value must be between 0.0 and 1.0 or Double.NaN.");
        }
        this.probs[nodeIndex][rowIndex][colIndex] = value;
    }

    @Override
    public int getCorrespondingNodeIndex(int nodeIndex, BayesIm otherBayesIm) {
        String nodeName = this.getNode(nodeIndex).getName();
        Node oldNode = otherBayesIm.getNode(nodeName);
        return otherBayesIm.getNodeIndex(oldNode);
    }

    @Override
    public void clearRow(int nodeIndex, int rowIndex) {
        for (int colIndex = 0; colIndex < this.getNumColumns(nodeIndex); ++colIndex) {
            this.setProbability(nodeIndex, rowIndex, colIndex, Double.NaN);
        }
    }

    @Override
    public void randomizeRow(int nodeIndex, int rowIndex) {
        int size = this.getNumColumns(nodeIndex);
        this.probs[nodeIndex][rowIndex] = MlBayesIm.getRandomWeights3(size);
    }

    private void randomizeRow2(int nodeIndex, int rowIndex, double[] biases) {
        int size = this.getNumColumns(nodeIndex);
        this.probs[nodeIndex][rowIndex] = MlBayesIm.getRandomWeights2(size, biases);
    }

    @Override
    public void randomizeIncompleteRows(int nodeIndex) {
        for (int rowIndex = 0; rowIndex < this.getNumRows(nodeIndex); ++rowIndex) {
            if (!this.isIncomplete(nodeIndex, rowIndex)) continue;
            this.randomizeRow(nodeIndex, rowIndex);
        }
    }

    @Override
    public void randomizeTable(int nodeIndex) {
        for (int rowIndex = 0; rowIndex < this.getNumRows(nodeIndex); ++rowIndex) {
            this.randomizeRow(nodeIndex, rowIndex);
        }
    }

    private void randomizeTable4(int nodeIndex) {
        for (int rowIndex = 0; rowIndex < this.getNumRows(nodeIndex); ++rowIndex) {
            this.randomizeRow(nodeIndex, rowIndex);
        }
        double[][] saved = new double[this.getNumRows(nodeIndex)][this.getNumColumns(nodeIndex)];
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 10; ++i) {
            for (int rowIndex = 0; rowIndex < this.getNumRows(nodeIndex); ++rowIndex) {
                this.randomizeRow2(nodeIndex, rowIndex, this.probs[nodeIndex][rowIndex]);
            }
            int score = this.score(nodeIndex);
            if ((double)score > max) {
                max = score;
                this.copy(this.probs[nodeIndex], saved);
            }
            if (score == this.getNumParents(nodeIndex)) break;
        }
        for (int rowIndex = 0; rowIndex < this.getNumRows(nodeIndex); ++rowIndex) {
            this.copy(saved, this.probs[nodeIndex]);
        }
    }

    private int score(int nodeIndex) {
        double[][] p = new double[this.getNumRows(nodeIndex)][this.getNumColumns(nodeIndex)];
        this.copy(this.probs[nodeIndex], p);
        int num = 0;
        int numRows = this.getNumRows(nodeIndex);
        for (int r = 0; r < p.length; ++r) {
            int c = 0;
            while (c < p[0].length) {
                double[] dArray = p[r];
                int n = c++;
                dArray[n] = dArray[n] / (double)numRows;
            }
        }
        int[] parents = this.getParents(nodeIndex);
        for (int t = 0; t < parents.length; ++t) {
            int numParentValues = this.getParentDim(nodeIndex, t);
            int numColumns = this.getNumColumns(nodeIndex);
            double[][] table = new double[numParentValues][numColumns];
            for (int childCol = 0; childCol < numColumns; ++childCol) {
                for (int parentValue = 0; parentValue < numParentValues; ++parentValue) {
                    for (int row = 0; row < numRows; ++row) {
                        if (this.getParentValues(nodeIndex, row)[t] != parentValue) continue;
                        double[] dArray = table[parentValue];
                        int n = childCol;
                        dArray[n] = dArray[n] + p[row][childCol];
                    }
                }
            }
            double N = 1000.0;
            for (int r = 0; r < table.length; ++r) {
                int c = 0;
                while (c < table[0].length) {
                    double[] dArray = table[r];
                    int n = c++;
                    dArray[n] = dArray[n] * 1000.0;
                }
            }
            double chisq = 0.0;
            for (int r = 0; r < table.length; ++r) {
                for (int c = 0; c < table[0].length; ++c) {
                    double _sumRow = this.sumRow(table, r);
                    double _sumCol = this.sumCol(table, c);
                    double exp = _sumRow / 1000.0 * (_sumCol / 1000.0) * 1000.0;
                    double obs = table[r][c];
                    chisq += FastMath.pow(obs - exp, 2) / exp;
                }
            }
            int dof = (table.length - 1) * (table[0].length - 1);
            ChiSquaredDistribution distribution = new ChiSquaredDistribution(dof);
            double prob = 1.0 - distribution.cumulativeProbability(chisq);
            num += prob < 1.0E-4 ? 1 : 0;
        }
        return num;
    }

    private double sumCol(double[][] marginals, int j) {
        double sum = 0.0;
        for (double[] marginal : marginals) {
            sum += marginal[j];
        }
        return sum;
    }

    private double sumRow(double[][] marginals, int i) {
        double sum = 0.0;
        for (int h = 0; h < marginals[i].length; ++h) {
            sum += marginals[i][h];
        }
        return sum;
    }

    private void copy(double[][] a, double[][] b) {
        for (int r = 0; r < a.length; ++r) {
            System.arraycopy(a[r], 0, b[r], 0, a[r].length);
        }
    }

    @Override
    public void clearTable(int nodeIndex) {
        for (int rowIndex = 0; rowIndex < this.getNumRows(nodeIndex); ++rowIndex) {
            this.clearRow(nodeIndex, rowIndex);
        }
    }

    @Override
    public boolean isIncomplete(int nodeIndex, int rowIndex) {
        for (int colIndex = 0; colIndex < this.getNumColumns(nodeIndex); ++colIndex) {
            double p = this.getProbability(nodeIndex, rowIndex, colIndex);
            if (!Double.isNaN(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIncomplete(int nodeIndex) {
        for (int rowIndex = 0; rowIndex < this.getNumRows(nodeIndex); ++rowIndex) {
            if (!this.isIncomplete(nodeIndex, rowIndex)) continue;
            return true;
        }
        return false;
    }

    public DataSet simulateData(int sampleSize, boolean latentDataSaved, int[] tiers) {
        if (this.getBayesPm().getDag().isTimeLagModel()) {
            return this.simulateTimeSeries(sampleSize);
        }
        return this.simulateDataHelper(sampleSize, latentDataSaved, tiers);
    }

    @Override
    public DataSet simulateData(int sampleSize, boolean latentDataSaved) {
        if (this.getBayesPm().getDag().isTimeLagModel()) {
            return this.simulateTimeSeries(sampleSize);
        }
        Graph graph = this.getBayesPm().getDag();
        if (graph.paths().existsDirectedCycle()) {
            throw new IllegalArgumentException("Graph must be acyclic to simulate from discrete Bayes net.");
        }
        Paths paths = graph.paths();
        List<Node> initialOrder = graph.getNodes();
        List<Node> tierOrdering = paths.getValidOrder(initialOrder, true);
        int[] tiers = new int[tierOrdering.size()];
        for (int i = 0; i < tierOrdering.size(); ++i) {
            tiers[i] = this.getNodeIndex(tierOrdering.get(i));
        }
        return this.simulateDataHelper(sampleSize, latentDataSaved, tiers);
    }

    public DataSet simulateData(DataSet dataSet, boolean latentDataSaved, int[] tiers) {
        return this.simulateDataHelper(dataSet, latentDataSaved, tiers);
    }

    @Override
    public DataSet simulateData(DataSet dataSet, boolean latentDataSaved) {
        Graph graph = this.getBayesPm().getDag();
        Paths paths = graph.paths();
        List<Node> initialOrder = graph.getNodes();
        List<Node> tierOrdering = paths.getValidOrder(initialOrder, true);
        int[] tiers = new int[tierOrdering.size()];
        for (int i = 0; i < tierOrdering.size(); ++i) {
            tiers[i] = this.getNodeIndex(tierOrdering.get(i));
        }
        return this.simulateDataHelper(dataSet, latentDataSaved, tiers);
    }

    private DataSet simulateTimeSeries(int sampleSize) {
        TimeLagGraph timeSeriesGraph = this.getBayesPm().getDag().getTimeLagGraph();
        ArrayList<Node> variables = new ArrayList<Node>();
        for (Node node : timeSeriesGraph.getLag0Nodes()) {
            DiscreteVariable e = new DiscreteVariable(timeSeriesGraph.getNodeId(node).getName());
            e.setNodeType(node.getNodeType());
            variables.add(e);
        }
        List<Node> lag0Nodes = timeSeriesGraph.getLag0Nodes();
        BoxDataSet fullData = new BoxDataSet(new VerticalIntDataBox(sampleSize, variables.size()), variables);
        Graph contemporaneousDag = timeSeriesGraph.subgraph(lag0Nodes);
        Paths paths = contemporaneousDag.paths();
        List<Node> initialOrder = contemporaneousDag.getNodes();
        List<Node> tierOrdering = paths.getValidOrder(initialOrder, true);
        int[] tiers = new int[tierOrdering.size()];
        for (int i = 0; i < tierOrdering.size(); ++i) {
            tiers[i] = this.getNodeIndex(tierOrdering.get(i));
        }
        int[] combination = new int[tierOrdering.size()];
        for (int i = 0; i < sampleSize; ++i) {
            int[] point = new int[this.nodes.length];
            block3: for (int nodeIndex : tiers) {
                double cutoff = RandomUtil.getInstance().nextDouble();
                for (int k = 0; k < this.getNumParents(nodeIndex); ++k) {
                    combination[k] = point[this.getParent(nodeIndex, k)];
                }
                int rowIndex = this.getRowIndex(nodeIndex, combination);
                double sum = 0.0;
                for (int k = 0; k < this.getNumColumns(nodeIndex); ++k) {
                    double probability = this.getProbability(nodeIndex, rowIndex, k);
                    if (Double.isNaN(probability)) {
                        throw new IllegalStateException("Some probability values in the BayesIm are not filled in; cannot simulate data.");
                    }
                    if (!((sum += probability) >= cutoff)) continue;
                    point[nodeIndex] = k;
                    continue block3;
                }
            }
        }
        return fullData;
    }

    private DataSet simulateDataHelper(int sampleSize, boolean latentDataSaved, int[] tiers) {
        int numMeasured = 0;
        int[] map = new int[this.nodes.length];
        LinkedList<Node> variables = new LinkedList<Node>();
        int j = 0;
        while (j < this.nodes.length) {
            int numCategories = this.bayesPm.getNumCategories(this.nodes[j]);
            LinkedList<String> categories = new LinkedList<String>();
            for (int k = 0; k < numCategories; ++k) {
                categories.add(this.bayesPm.getCategory(this.nodes[j], k));
            }
            DiscreteVariable var = new DiscreteVariable(this.nodes[j].getName(), categories);
            var.setNodeType(this.nodes[j].getNodeType());
            variables.add(var);
            int index = ++numMeasured - 1;
            map[index] = j++;
        }
        DataSet dataSet = new BoxDataSet(new VerticalIntDataBox(sampleSize, variables.size()), variables);
        this.constructSample(sampleSize, dataSet, map, tiers);
        if (!latentDataSaved) {
            dataSet = DataTransforms.restrictToMeasured(dataSet);
        }
        return dataSet;
    }

    private DataSet simulateDataHelper(DataSet dataSet, boolean latentDataSaved, int[] tiers) {
        if (dataSet.getNumColumns() != this.nodes.length) {
            throw new IllegalArgumentException("When rewriting the old data set, number of variables in data set must equal number of variables in Bayes net.");
        }
        int sampleSize = dataSet.getNumRows();
        int numVars = 0;
        int[] map = new int[this.nodes.length];
        LinkedList<DiscreteVariable> variables = new LinkedList<DiscreteVariable>();
        int j = 0;
        while (j < this.nodes.length) {
            int numCategories = this.bayesPm.getNumCategories(this.nodes[j]);
            LinkedList<String> categories = new LinkedList<String>();
            for (int k = 0; k < numCategories; ++k) {
                categories.add(this.bayesPm.getCategory(this.nodes[j], k));
            }
            DiscreteVariable var = new DiscreteVariable(this.nodes[j].getName(), categories);
            var.setNodeType(this.nodes[j].getNodeType());
            variables.add(var);
            int index = ++numVars - 1;
            map[index] = j++;
        }
        for (int i = 0; i < variables.size(); ++i) {
            Node node = dataSet.getVariable(i);
            Node _node = (Node)variables.get(i);
            dataSet.changeVariable(node, _node);
        }
        this.constructSample(sampleSize, dataSet, map, tiers);
        if (latentDataSaved) {
            return dataSet;
        }
        return DataTransforms.restrictToMeasured(dataSet);
    }

    private void constructSample(int sampleSize, DataSet dataSet, int[] map, int[] tiers) {
        for (int i = 0; i < sampleSize; ++i) {
            block1: for (int t : tiers) {
                int[] parentValues = new int[this.parents[t].length];
                for (int k = 0; k < parentValues.length; ++k) {
                    parentValues[k] = dataSet.getInt(i, this.parents[t][k]);
                }
                int rowIndex = this.getRowIndex(t, parentValues);
                double sum = 0.0;
                double r = RandomUtil.getInstance().nextDouble();
                for (int k = 0; k < this.getNumColumns(t); ++k) {
                    double probability = this.getProbability(t, rowIndex, k);
                    if (!((sum += probability) >= r)) continue;
                    dataSet.setInt(i, map[t], k);
                    continue block1;
                }
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BayesIm)) {
            return false;
        }
        BayesIm otherIm = (BayesIm)o;
        if (this.getNumNodes() != otherIm.getNumNodes()) {
            return false;
        }
        for (int i = 0; i < this.getNumNodes(); ++i) {
            int otherIndex = otherIm.getCorrespondingNodeIndex(i, otherIm);
            if (otherIndex == -1) {
                return false;
            }
            if (this.getNumColumns(i) != otherIm.getNumColumns(otherIndex)) {
                return false;
            }
            if (this.getNumRows(i) != otherIm.getNumRows(otherIndex)) {
                return false;
            }
            for (int j = 0; j < this.getNumRows(i); ++j) {
                for (int k = 0; k < this.getNumColumns(i); ++k) {
                    double prob = this.getProbability(i, j, k);
                    double otherProb = otherIm.getProbability(i, j, k);
                    if (Double.isNaN(prob) && Double.isNaN(otherProb) || !(FastMath.abs(prob - otherProb) > 0.001)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        for (int i = 0; i < this.getNumNodes(); ++i) {
            buf.append("\n\nNode: ").append(this.getNode(i));
            if (this.getNumParents(i) == 0) {
                buf.append("\n");
            } else {
                buf.append("\n\n");
                for (int k = 0; k < this.getNumParents(i); ++k) {
                    buf.append(this.getNode(this.getParent(i, k))).append("\t");
                }
            }
            for (int j = 0; j < this.getNumRows(i); ++j) {
                int k;
                buf.append("\n");
                for (k = 0; k < this.getNumParents(i); ++k) {
                    buf.append(this.getParentValue(i, j, k));
                    if (k >= this.getNumParents(i) - 1) continue;
                    buf.append("\t");
                }
                if (this.getNumParents(i) > 0) {
                    buf.append("\t");
                }
                for (k = 0; k < this.getNumColumns(i); ++k) {
                    buf.append(nf.format(this.getProbability(i, j, k))).append("\t");
                }
            }
        }
        buf.append("\n");
        return buf.toString();
    }

    private void initialize(BayesIm oldBayesIm, int initializationMethod) {
        this.parents = new int[this.nodes.length][];
        this.parentDims = new int[this.nodes.length][];
        this.probs = new double[this.nodes.length][][];
        for (int nodeIndex = 0; nodeIndex < this.nodes.length; ++nodeIndex) {
            this.initializeNode(nodeIndex, oldBayesIm, initializationMethod);
        }
    }

    private void initializeNode(int nodeIndex, BayesIm oldBayesIm, int initializationMethod) {
        Node node = this.nodes[nodeIndex];
        Graph graph = this.getBayesPm().getDag();
        ArrayList<Node> parentList = new ArrayList<Node>(graph.getParents(node));
        int[] parentArray = new int[parentList.size()];
        for (int i = 0; i < parentList.size(); ++i) {
            parentArray[i] = this.getNodeIndex((Node)parentList.get(i));
        }
        Arrays.sort(parentArray);
        this.parents[nodeIndex] = parentArray;
        int[] dims = new int[parentArray.length];
        for (int i = 0; i < dims.length; ++i) {
            Node node2 = this.nodes[parentArray[i]];
            dims[i] = this.getBayesPm().getNumCategories(node2);
        }
        int numRows = 1;
        for (int dim : dims) {
            if (numRows > 1000000) {
                throw new IllegalArgumentException("The number of rows in the conditional probability table for " + this.nodes[nodeIndex] + " is greater than 1,000,000 and cannot be represented.");
            }
            numRows *= dim;
        }
        int n = this.getBayesPm().getNumCategories(node);
        this.parentDims[nodeIndex] = dims;
        this.probs[nodeIndex] = new double[numRows][n];
        if (initializationMethod == 1) {
            this.randomizeTable(nodeIndex);
        } else {
            for (int rowIndex = 0; rowIndex < numRows; ++rowIndex) {
                if (oldBayesIm == null) {
                    this.overwriteRow(nodeIndex, rowIndex, initializationMethod);
                    continue;
                }
                this.retainOldRowIfPossible(nodeIndex, rowIndex, oldBayesIm, initializationMethod);
            }
        }
    }

    private void overwriteRow(int nodeIndex, int rowIndex, int initializationMethod) {
        if (initializationMethod == 1) {
            this.randomizeRow(nodeIndex, rowIndex);
        } else if (initializationMethod == 0) {
            this.initializeRowAsUnknowns(nodeIndex, rowIndex);
        } else {
            throw new IllegalArgumentException("Unrecognized state.");
        }
    }

    private void initializeRowAsUnknowns(int nodeIndex, int rowIndex) {
        int size = this.getNumColumns(nodeIndex);
        double[] row = new double[size];
        Arrays.fill(row, Double.NaN);
        this.probs[nodeIndex][rowIndex] = row;
    }

    private void retainOldRowIfPossible(int nodeIndex, int rowIndex, BayesIm oldBayesIm, int initializationMethod) {
        int oldNodeIndex = this.getCorrespondingNodeIndex(nodeIndex, oldBayesIm);
        if (oldNodeIndex == -1) {
            this.overwriteRow(nodeIndex, rowIndex, initializationMethod);
        } else if (this.getNumColumns(nodeIndex) != oldBayesIm.getNumColumns(oldNodeIndex)) {
            this.overwriteRow(nodeIndex, rowIndex, initializationMethod);
        } else {
            int oldRowIndex = this.getUniqueCompatibleOldRow(nodeIndex, rowIndex, oldBayesIm);
            if (oldRowIndex >= 0) {
                this.copyValuesFromOldToNew(oldNodeIndex, oldRowIndex, nodeIndex, rowIndex, oldBayesIm);
            } else {
                this.overwriteRow(nodeIndex, rowIndex, initializationMethod);
            }
        }
    }

    private int getUniqueCompatibleOldRow(int nodeIndex, int rowIndex, BayesIm oldBayesIm) {
        int oldNodeIndex = this.getCorrespondingNodeIndex(nodeIndex, oldBayesIm);
        int oldNumParents = oldBayesIm.getNumParents(oldNodeIndex);
        int[] oldParentValues = new int[oldNumParents];
        Arrays.fill(oldParentValues, -1);
        int[] parentValues = this.getParentValues(nodeIndex, rowIndex);
        for (int i = 0; i < this.getNumParents(nodeIndex); ++i) {
            int parentNodeIndex = this.getParent(nodeIndex, i);
            int oldParentNodeIndex = this.getCorrespondingNodeIndex(parentNodeIndex, oldBayesIm);
            int oldParentIndex = -1;
            for (int j = 0; j < oldBayesIm.getNumParents(oldNodeIndex); ++j) {
                if (oldParentNodeIndex != oldBayesIm.getParent(oldNodeIndex, j)) continue;
                oldParentIndex = j;
                break;
            }
            if (oldParentIndex == -1 || oldParentIndex >= oldBayesIm.getNumParents(oldNodeIndex)) {
                return -1;
            }
            int newParentValue = parentValues[i];
            int oldParentDim = oldBayesIm.getParentDim(oldNodeIndex, oldParentIndex);
            if (newParentValue >= oldParentDim) {
                return -1;
            }
            oldParentValues[oldParentIndex] = newParentValue;
        }
        for (int oldParentValue : oldParentValues) {
            if (oldParentValue != -1) continue;
            return -1;
        }
        return oldBayesIm.getRowIndex(oldNodeIndex, oldParentValues);
    }

    private void copyValuesFromOldToNew(int oldNodeIndex, int oldRowIndex, int nodeIndex, int rowIndex, BayesIm oldBayesIm) {
        if (this.getNumColumns(nodeIndex) != oldBayesIm.getNumColumns(oldNodeIndex)) {
            throw new IllegalArgumentException("It's only possible to copy one row of probability values to another in a Bayes IM if the number of columns in the table are the same.");
        }
        for (int colIndex = 0; colIndex < this.getNumColumns(nodeIndex); ++colIndex) {
            double prob = oldBayesIm.getProbability(oldNodeIndex, oldRowIndex, colIndex);
            this.setProbability(nodeIndex, rowIndex, colIndex, prob);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesPm == null) {
            throw new NullPointerException();
        }
        if (this.nodes == null) {
            throw new NullPointerException();
        }
        if (this.parents == null) {
            throw new NullPointerException();
        }
        if (this.parentDims == null) {
            throw new NullPointerException();
        }
        if (this.probs == null) {
            throw new NullPointerException();
        }
    }
}

