/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class ModelGenerator {
    public static List<Graph> generate(Graph graph) {
        EdgeListGraph toAdd;
        if (graph.paths().existsDirectedCycle()) {
            throw new IllegalArgumentException("Input must not contain cycles.");
        }
        LinkedList<Graph> graphs = new LinkedList<Graph>();
        Set<Edge> allEdges = graph.getEdges();
        List<Node> allNodes = graph.getNodes();
        for (Edge allEdge1 : allEdges) {
            toAdd = new EdgeListGraph(graph);
            toAdd.removeEdge(allEdge1);
            graphs.add(toAdd);
        }
        for (Edge allEdge : allEdges) {
            toAdd = new EdgeListGraph(graph);
            Endpoint e1 = allEdge.getEndpoint1();
            Endpoint e2 = allEdge.getEndpoint2();
            Node n1 = allEdge.getNode1();
            Node n2 = allEdge.getNode2();
            Edge newEdge = new Edge(n1, n2, e2, e1);
            toAdd.removeEdge(allEdge);
            if (toAdd.paths().existsDirectedPathFromTo(n1, n2)) continue;
            toAdd.addEdge(newEdge);
            graphs.add(toAdd);
        }
        for (int i = 0; i < allNodes.size(); ++i) {
            Node node1 = allNodes.get(i);
            for (int j = i + 1; j < allNodes.size(); ++j) {
                EdgeListGraph toAdd2;
                Node node2 = allNodes.get(j);
                if (graph.isParentOf(node1, node2) || graph.isParentOf(node2, node1)) continue;
                EdgeListGraph toAdd1 = new EdgeListGraph(graph);
                if (!toAdd1.paths().existsDirectedPathFromTo(node1, node2)) {
                    Edge newN2N1 = new Edge(node2, node1, Endpoint.TAIL, Endpoint.ARROW);
                    toAdd1.addEdge(newN2N1);
                    graphs.add(toAdd1);
                }
                if ((toAdd2 = new EdgeListGraph(graph)).paths().existsDirectedPathFromTo(node2, node1)) continue;
                Edge newN1N2 = new Edge(node1, node2, Endpoint.TAIL, Endpoint.ARROW);
                toAdd2.addEdge(newN1N2);
                graphs.add(toAdd2);
            }
        }
        return graphs;
    }
}

