/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.MlBayesImObs;
import edu.cmu.tetrad.bayes.Proposition;

final class QList {
    private final int nVariables;
    private boolean inNumerator;
    private int[] sumOverVariables;
    private int[] probTerm;
    private QList subList;
    private QList nextTerm;

    public QList(int nVariables) {
        this.nVariables = nVariables;
        this.initialize();
    }

    public QList(int nVariables, int[] probTerm) {
        this.nVariables = nVariables;
        this.initialize();
        System.arraycopy(probTerm, 0, this.probTerm, 0, nVariables);
        this.inNumerator = true;
    }

    private QList(QList q) {
        this.nVariables = q.nVariables;
        this.initialize();
        for (int i = 0; i < this.nVariables; ++i) {
            this.sumOverVariables[i] = q.sumOverVariables[i];
            this.probTerm[i] = q.probTerm[i];
        }
        this.inNumerator = q.inNumerator;
        if (q.subList != null) {
            this.subList = new QList(q.subList);
        }
        if (q.nextTerm != null) {
            this.nextTerm = new QList(q.nextTerm);
        }
    }

    public void add(QList q, int[] sumOverVariables, boolean inNumerator) {
        QList qAdd = new QList(this.nVariables);
        qAdd.initialize();
        qAdd.inNumerator = inNumerator;
        System.arraycopy(sumOverVariables, 0, qAdd.sumOverVariables, 0, this.nVariables);
        qAdd.subList = new QList(q);
        if (this.nextTerm == null) {
            this.nextTerm = new QList(qAdd);
        } else {
            QList curTerm = this.nextTerm;
            while (curTerm.nextTerm != null) {
                curTerm = curTerm.nextTerm;
            }
            curTerm.nextTerm = new QList(qAdd);
        }
    }

    public void printQList(int index1, int index2) {
        int i;
        System.out.println("======= " + index1 + "  " + index2 + ": printQList");
        System.out.println("inNumerator: " + this.inNumerator);
        System.out.print("sumOverVariables: ");
        for (i = 0; i < this.nVariables; ++i) {
            System.out.print(this.sumOverVariables[i] + "  ");
        }
        System.out.println();
        if (this.subList == null) {
            System.out.print("probTerm: ");
            for (i = 0; i < this.nVariables; ++i) {
                System.out.print(this.probTerm[i] + "  ");
            }
            System.out.println();
        } else {
            System.out.println("--------------------------------------- " + (index1 + 1) + "  " + 0 + ": subList");
            this.subList.printQList(index1 + 1, 0);
        }
        if (this.nextTerm != null) {
            System.out.println("---------------------------- " + index1 + "  " + ++index2 + ": nextTerm");
            this.nextTerm.printQList(index1, index2);
        }
    }

    public double computeValue(BayesIm bayesIm, int[] fixedVarValues) {
        double resultAll = 0.0;
        double resultNextTerm = 1.0;
        int nNodes = bayesIm.getNumNodes();
        int[] loopVarValues = new int[nNodes];
        for (int i = 0; i < nNodes; ++i) {
            loopVarValues[i] = fixedVarValues[i];
            if (this.sumOverVariables[i] != 1) continue;
            loopVarValues[i] = 0;
        }
        int curVar = nNodes - 1;
        while (curVar >= 0) {
            double resultOneConfig;
            if (this.subList == null) {
                int nVarInMarginal = 0;
                for (int i = 0; i < nNodes; ++i) {
                    if (this.probTerm[i] != 1) continue;
                    ++nVarInMarginal;
                }
                int[] pVar = new int[nVarInMarginal];
                int[] pValues = new int[nVarInMarginal];
                int pIndex = 0;
                for (int i = 0; i < nNodes; ++i) {
                    if (this.probTerm[i] != 1) continue;
                    pVar[pIndex] = i;
                    pValues[pIndex] = loopVarValues[i] == -1 ? 0 : loopVarValues[i];
                    ++pIndex;
                }
                Proposition prop = Proposition.tautology(bayesIm);
                for (int i = 0; i < nVarInMarginal; ++i) {
                    prop.setCategory(pVar[i], pValues[i]);
                }
                Proposition propObs = new Proposition(((MlBayesImObs)bayesIm).getBayesImObs(), prop);
                resultOneConfig = ((MlBayesImObs)bayesIm).getJPD().getProb(propObs);
            } else {
                resultOneConfig = this.subList.computeValue(bayesIm, loopVarValues);
            }
            resultAll += resultOneConfig;
            if (this.sumOverVariables[curVar] == 1 && loopVarValues[curVar] < bayesIm.getNumColumns(curVar) - 1) {
                int n = curVar;
                loopVarValues[n] = loopVarValues[n] + 1;
                continue;
            }
            while (curVar >= 0 && (this.sumOverVariables[curVar] != 1 || loopVarValues[curVar] == bayesIm.getNumColumns(curVar) - 1)) {
                --curVar;
            }
            if (curVar < 0) continue;
            int n = curVar;
            loopVarValues[n] = loopVarValues[n] + 1;
            for (int j = curVar + 1; j < nNodes; ++j) {
                if (this.sumOverVariables[j] != 1) continue;
                loopVarValues[j] = 0;
            }
            curVar = nNodes - 1;
        }
        if (this.nextTerm != null) {
            resultNextTerm = this.nextTerm.computeValue(bayesIm, fixedVarValues);
        }
        if (this.inNumerator) {
            return resultAll * resultNextTerm;
        }
        return 1.0 / resultAll * resultNextTerm;
    }

    private void initialize() {
        this.sumOverVariables = new int[this.nVariables];
        this.probTerm = new int[this.nVariables];
        for (int i = 0; i < this.nVariables; ++i) {
            this.sumOverVariables[i] = 0;
            this.probTerm[i] = 0;
        }
        this.inNumerator = true;
        this.subList = null;
        this.nextTerm = null;
    }
}

