/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public final class UpdatedBayesIm
implements BayesIm {
    private static final long serialVersionUID = 23L;
    private static final double ALLOWABLE_DIFFERENCE = 1.0E-10;
    private final BayesIm bayesIm;
    private final Evidence evidence;
    private final double[][][] changedProbs;
    private final boolean[] affectedVars;

    public UpdatedBayesIm(BayesIm bayesIm) {
        this(bayesIm, Evidence.tautology(bayesIm));
    }

    public UpdatedBayesIm(BayesIm bayesIm, Evidence evidence) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        if (evidence == null) {
            throw new NullPointerException();
        }
        if (evidence.isIncompatibleWith(bayesIm)) {
            throw new IllegalArgumentException("Variables for this evidence must be compatible with those of the model Bayes IM");
        }
        this.bayesIm = bayesIm;
        this.evidence = new Evidence(evidence, bayesIm);
        this.changedProbs = new double[bayesIm.getNumNodes()][][];
        this.affectedVars = this.ancestorsOfEvidence(evidence);
    }

    public static UpdatedBayesIm serializableInstance() {
        return new UpdatedBayesIm(MlBayesIm.serializableInstance());
    }

    private static boolean hasNextValue(Proposition proposition, int variable, int curIndex) {
        return UpdatedBayesIm.nextValue(proposition, variable, curIndex) != -1;
    }

    private static int nextValue(Proposition proposition, int variable, int curIndex) {
        for (int i = curIndex + 1; i < proposition.getNumCategories(variable); ++i) {
            if (!proposition.isAllowed(variable, i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public BayesPm getBayesPm() {
        return this.getBayesIm().getBayesPm();
    }

    private BayesIm getBayesIm() {
        return this.bayesIm;
    }

    @Override
    public Graph getDag() {
        return this.getBayesIm().getDag();
    }

    @Override
    public int getNumNodes() {
        return this.getBayesIm().getNumNodes();
    }

    @Override
    public Node getNode(int nodeIndex) {
        return this.getBayesIm().getNode(nodeIndex);
    }

    @Override
    public Node getNode(String name) {
        return this.getBayesIm().getNode(name);
    }

    @Override
    public int getNodeIndex(Node node) {
        return this.getBayesIm().getNodeIndex(node);
    }

    @Override
    public int getNumColumns(int nodeIndex) {
        return this.getBayesIm().getNumColumns(nodeIndex);
    }

    @Override
    public int getNumRows(int nodeIndex) {
        return this.getBayesIm().getNumRows(nodeIndex);
    }

    @Override
    public int getNumParents(int nodeIndex) {
        return this.getBayesIm().getNumParents(nodeIndex);
    }

    @Override
    public int getParent(int nodeIndex, int parentIndex) {
        return this.getBayesIm().getParent(nodeIndex, parentIndex);
    }

    @Override
    public int getParentDim(int nodeIndex, int parentIndex) {
        return this.getBayesIm().getParentDim(nodeIndex, parentIndex);
    }

    @Override
    public int[] getParentDims(int nodeIndex) {
        return this.getBayesIm().getParentDims(nodeIndex);
    }

    @Override
    public int[] getParents(int nodeIndex) {
        return this.getBayesIm().getParents(nodeIndex);
    }

    @Override
    public int[] getParentValues(int nodeIndex, int rowIndex) {
        return this.getBayesIm().getParentValues(nodeIndex, rowIndex);
    }

    @Override
    public int getParentValue(int nodeIndex, int rowIndex, int colIndex) {
        return this.getBayesIm().getParentValue(nodeIndex, rowIndex, colIndex);
    }

    @Override
    public double getProbability(int nodeIndex, int rowIndex, int colIndex) {
        if (!this.affectedVars[nodeIndex]) {
            return this.getBayesIm().getProbability(nodeIndex, rowIndex, colIndex);
        }
        if (this.changedProbs[nodeIndex] == null) {
            double[][] table;
            int numRows = this.getNumRows(nodeIndex);
            int numCols = this.getNumColumns(nodeIndex);
            for (double[] aTable : table = new double[numRows][numCols]) {
                Arrays.fill(aTable, -99.0);
            }
            this.changedProbs[nodeIndex] = table;
        }
        if (this.changedProbs[nodeIndex][rowIndex][colIndex] == -99.0) {
            this.changedProbs[nodeIndex][rowIndex][colIndex] = this.calcUpdatedProb(nodeIndex, rowIndex, colIndex);
        }
        return this.changedProbs[nodeIndex][rowIndex][colIndex];
    }

    @Override
    public int getRowIndex(int nodeIndex, int[] values) {
        return this.getBayesIm().getRowIndex(nodeIndex, values);
    }

    @Override
    public void normalizeAll() {
        this.getBayesIm().normalizeAll();
    }

    @Override
    public void normalizeNode(int nodeIndex) {
        this.getBayesIm().normalizeNode(nodeIndex);
    }

    @Override
    public void normalizeRow(int nodeIndex, int rowIndex) {
        this.getBayesIm().normalizeRow(nodeIndex, rowIndex);
    }

    @Override
    public void setProbability(int nodeIndex, double[][] probMatrix) {
        this.getBayesIm().setProbability(nodeIndex, probMatrix);
    }

    @Override
    public void setProbability(int nodeIndex, int rowIndex, int colIndex, double value) {
        this.getBayesIm().setProbability(nodeIndex, rowIndex, colIndex, value);
    }

    @Override
    public int getCorrespondingNodeIndex(int nodeIndex, BayesIm otherBayesIm) {
        return this.getBayesIm().getCorrespondingNodeIndex(nodeIndex, otherBayesIm);
    }

    @Override
    public void clearRow(int nodeIndex, int rowIndex) {
        this.getBayesIm().clearRow(nodeIndex, rowIndex);
    }

    @Override
    public void randomizeRow(int nodeIndex, int rowIndex) {
        this.getBayesIm().randomizeRow(nodeIndex, rowIndex);
    }

    @Override
    public void randomizeIncompleteRows(int nodeIndex) {
        this.getBayesIm().randomizeIncompleteRows(nodeIndex);
    }

    @Override
    public void randomizeTable(int nodeIndex) {
        this.getBayesIm().randomizeTable(nodeIndex);
    }

    @Override
    public void clearTable(int nodeIndex) {
        this.getBayesIm().clearTable(nodeIndex);
    }

    @Override
    public boolean isIncomplete(int nodeIndex, int rowIndex) {
        return this.getBayesIm().isIncomplete(nodeIndex, rowIndex);
    }

    @Override
    public boolean isIncomplete(int nodeIndex) {
        return this.getBayesIm().isIncomplete(nodeIndex);
    }

    @Override
    public DataSet simulateData(int sampleSize, boolean latentDataSaved) {
        return this.getBayesIm().simulateData(sampleSize, latentDataSaved);
    }

    @Override
    public DataSet simulateData(DataSet dataSet, boolean latentDataSaved) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Node> getVariables() {
        return this.getBayesIm().getVariables();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getBayesIm().getVariableNames();
    }

    @Override
    public List<Node> getMeasuredNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BayesIm)) {
            return false;
        }
        BayesIm otherIm = (BayesIm)o;
        if (this.getNumNodes() != otherIm.getNumNodes()) {
            return false;
        }
        for (int i = 0; i < this.getNumNodes(); ++i) {
            int otherIndex = otherIm.getCorrespondingNodeIndex(i, otherIm);
            if (otherIndex == -1) {
                return false;
            }
            if (this.getNumColumns(i) != otherIm.getNumColumns(otherIndex)) {
                return false;
            }
            if (this.getNumRows(i) != otherIm.getNumRows(otherIndex)) {
                return false;
            }
            for (int j = 0; j < this.getNumRows(i); ++j) {
                for (int k = 0; k < this.getNumColumns(i); ++k) {
                    double prob = this.getProbability(i, j, k);
                    double otherProb = otherIm.getProbability(i, j, k);
                    if (Double.isNaN(prob) && Double.isNaN(otherProb) || !(FastMath.abs(prob - otherProb) > 1.0E-10)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        buf.append("\nBayesIm:");
        for (int i = 0; i < this.getNumNodes(); ++i) {
            buf.append("\n\nNode #").append(i);
            buf.append("\n");
            for (int k = 0; k < this.getNumParents(i); ++k) {
                buf.append("#").append(this.getParent(i, k)).append("\t");
            }
            for (int j = 0; j < this.getNumRows(i); ++j) {
                int k;
                buf.append("\n");
                for (k = 0; k < this.getNumParents(i); ++k) {
                    buf.append(this.getParentValue(i, j, k)).append("\t");
                }
                buf.append(":\t");
                for (k = 0; k < this.getNumColumns(i); ++k) {
                    buf.append(nf.format(this.getProbability(i, j, k))).append("\t");
                }
            }
        }
        return buf.toString();
    }

    public Evidence getEvidence() {
        return new Evidence(this.evidence, this);
    }

    private boolean[] ancestorsOfEvidence(Evidence evidence) {
        List<Node> variablesInEvidence = evidence.getVariablesInEvidence();
        LinkedList<Node> nodesInEvidence = new LinkedList<Node>();
        for (Node _node : variablesInEvidence) {
            String nodeName = _node.getName();
            nodesInEvidence.add(this.bayesIm.getBayesPm().getNode(nodeName));
        }
        List<Node> nodesInGraph = this.getBayesIm().getDag().getNodes();
        boolean[] ancestorsOfEvidence = new boolean[this.getBayesIm().getNumNodes()];
        for (int i = 0; i < nodesInGraph.size(); ++i) {
            for (Node node2 : nodesInEvidence) {
                Node node1 = nodesInGraph.get(i);
                if (!this.getBayesIm().getDag().paths().isAncestorOf(node1, node2) && !this.getBayesIm().getDag().isChildOf(node1, node2)) continue;
                ancestorsOfEvidence[i] = true;
            }
        }
        return ancestorsOfEvidence;
    }

    private double calcUpdatedProb(int nodeIndex, int rowIndex, int colIndex) {
        if (!this.affectedVars[nodeIndex]) {
            throw new IllegalStateException("Should not be calculating a probability for a table that's not an ancestor of evidence.");
        }
        Proposition assertion = Proposition.tautology(this.getBayesIm());
        Proposition condition = new Proposition(this.evidence.getProposition());
        boolean[] relevantVars = this.calcRelevantVars(nodeIndex);
        assertion.setCategory(nodeIndex, colIndex);
        int[] parents = this.getBayesIm().getParents(nodeIndex);
        int[] parentValues = this.getBayesIm().getParentValues(nodeIndex, rowIndex);
        for (int k = 0; k < parents.length; ++k) {
            condition.disallowComplement(parents[k], parentValues[k]);
        }
        if (condition.existsCombination()) {
            return this.getConditionalProb(assertion, condition, relevantVars);
        }
        return Double.NaN;
    }

    private double getConditionalProb(Proposition assertion, Proposition condition, boolean[] relevantVars) {
        if (assertion.getVariableSource() != condition.getVariableSource()) {
            throw new IllegalArgumentException("Assertion and condition must be for the same Bayes IM.");
        }
        for (int i = 0; i < relevantVars.length; ++i) {
            if (relevantVars[i]) continue;
            condition.setCategory(i, 0);
        }
        int[] variableValues = new int[condition.getNumVariables()];
        for (int i = 0; i < condition.getNumVariables(); ++i) {
            variableValues[i] = UpdatedBayesIm.nextValue(condition, i, -1);
        }
        variableValues[variableValues.length - 1] = -1;
        double conditionTrue = 0.0;
        double assertionTrue = 0.0;
        block2: while (true) {
            for (int i = condition.getNumVariables() - 1; i >= 0; --i) {
                if (!UpdatedBayesIm.hasNextValue(condition, i, variableValues[i])) continue;
                variableValues[i] = UpdatedBayesIm.nextValue(condition, i, variableValues[i]);
                for (int j = i + 1; j < condition.getNumVariables(); ++j) {
                    if (!UpdatedBayesIm.hasNextValue(condition, j, -1)) break block2;
                    variableValues[j] = UpdatedBayesIm.nextValue(condition, j, -1);
                }
                double cellProb = this.getCellProb(variableValues);
                if (Double.isNaN(cellProb)) continue;
                conditionTrue += cellProb;
                if (!assertion.isPermissibleCombination(variableValues)) continue;
                assertionTrue += cellProb;
            }
            break;
        }
        return assertionTrue / conditionTrue;
    }

    private double getCellProb(int[] variableValues) {
        double p = 1.0;
        for (int node = 0; node < variableValues.length; ++node) {
            int[] parents = this.getBayesIm().getParents(node);
            int[] parentValues = new int[parents.length];
            for (int parentIndex = 0; parentIndex < parentValues.length; ++parentIndex) {
                parentValues[parentIndex] = variableValues[parents[parentIndex]];
            }
            int rowIndex = this.getBayesIm().getRowIndex(node, parentValues);
            int colIndex = variableValues[node];
            p *= this.getBayesIm().getProbability(node, rowIndex, colIndex);
        }
        return p;
    }

    private boolean[] calcRelevantVars(int nodeIndex) {
        boolean[] relevantVars = new boolean[this.evidence.getNumNodes()];
        Node node = this.bayesIm.getNode(nodeIndex);
        List<Node> variablesInEvidence = this.evidence.getVariablesInEvidence();
        LinkedList<Node> nodesInEvidence = new LinkedList<Node>();
        for (Node _node : variablesInEvidence) {
            nodesInEvidence.add(this.bayesIm.getBayesPm().getNode(_node.getName()));
        }
        HashSet<Node> conditionedNodes = new HashSet<Node>(nodesInEvidence);
        conditionedNodes.addAll(this.bayesIm.getDag().getParents(node));
        for (int i = 0; i < this.bayesIm.getNumNodes(); ++i) {
            Node node2 = this.bayesIm.getNode(i);
            if (node != node2 && !this.bayesIm.getDag().paths().isMConnectedTo(node, node2, conditionedNodes)) continue;
            relevantVars[i] = true;
        }
        return relevantVars;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

