/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.calculator;

import edu.cmu.tetrad.calculator.expression.ConstantExpression;
import edu.cmu.tetrad.calculator.expression.Context;
import edu.cmu.tetrad.calculator.expression.Equation;
import edu.cmu.tetrad.calculator.expression.Expression;
import edu.cmu.tetrad.calculator.expression.VariableExpression;
import edu.cmu.tetrad.calculator.parser.ExpressionParser;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Transformation {
    private Transformation() {
    }

    public static void transform(DataSet data, String ... equations) throws ParseException {
        if (equations.length == 0) {
            return;
        }
        for (String equation : equations) {
            Transformation.transformEquation(data, equation);
        }
    }

    private static void transformEquation(DataSet data, String eq) throws ParseException {
        ExpressionParser parser = new ExpressionParser(data.getVariableNames(), ExpressionParser.RestrictionType.MAY_ONLY_CONTAIN);
        Equation equation = parser.parseEquation(eq);
        Transformation.addVariableIfRequired(data, equation.getVariable());
        Expression expression = equation.getExpression();
        Node variable = data.getVariable(equation.getVariable());
        if (variable == null) {
            throw new IllegalStateException("Unknown variable " + equation.getVariable());
        }
        int column = data.getColumn(variable);
        List<String> contextVars = Transformation.getContextVariables(expression);
        DataBackedContext context = new DataBackedContext(data, contextVars);
        int rows = data.getNumRows();
        for (int row = 0; row < rows; ++row) {
            context.setRow(row);
            double newValue = expression.evaluate(context);
            data.setDouble(row, column, newValue);
        }
    }

    private static void addVariableIfRequired(DataSet data, String var) {
        List<String> nodes = data.getVariableNames();
        if (!nodes.contains(var)) {
            data.addVariable(new ContinuousVariable(var));
        }
    }

    private static List<String> getContextVariables(Expression exp) {
        ArrayList<String> variables = new ArrayList<String>();
        for (Expression sub : exp.getExpressions()) {
            if (sub instanceof VariableExpression) {
                variables.add(((VariableExpression)sub).getVariable());
                continue;
            }
            if (sub instanceof ConstantExpression) continue;
            variables.addAll(Transformation.getContextVariables(sub));
        }
        return variables;
    }

    private static class DataBackedContext
    implements Context {
        private final DataSet data;
        private final Map<String, Integer> indexes = new HashMap<String, Integer>();
        private int row;

        public DataBackedContext(DataSet data, List<String> vars) {
            this.data = data;
            for (String v : vars) {
                Node n = data.getVariable(v);
                this.indexes.put(v, data.getColumn(n));
            }
        }

        public void setRow(int row) {
            this.row = row;
        }

        @Override
        public Double getValue(String var) {
            Integer i = this.indexes.get(var);
            if (i != null) {
                return this.data.getDouble(this.row, i);
            }
            return null;
        }
    }
}

