/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.calculator.expression;

import edu.cmu.tetrad.calculator.expression.Context;
import edu.cmu.tetrad.calculator.expression.Expression;
import edu.cmu.tetrad.calculator.expression.ExpressionDescriptor;
import edu.cmu.tetrad.calculator.expression.VariableExpression;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.RealDistribution;

public class EvaluationExpression
implements Expression {
    private static final long serialVersionUID = 23L;
    private final VariableExpression variable;
    private final String string;

    public EvaluationExpression(VariableExpression exp, String s) {
        if (exp == null) {
            throw new NullPointerException("Variable must not be null.");
        }
        if (s == null) {
            throw new NullPointerException("String must not be null.");
        }
        this.variable = exp;
        this.string = s;
    }

    public static EvaluationExpression serializableInstance() {
        return new EvaluationExpression(VariableExpression.serializableInstance(), "a");
    }

    @Override
    public double evaluate(Context context) {
        Double o = this.variable.evaluateGeneric(context);
        if (o != null && this.string.equals(((Object)o).toString())) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public String getToken() {
        return "Eval";
    }

    @Override
    public ExpressionDescriptor.Position getPosition() {
        return ExpressionDescriptor.Position.NEITHER;
    }

    @Override
    public List<Expression> getExpressions() {
        return Collections.singletonList(this.variable);
    }

    @Override
    public RealDistribution getRealDistribution(Context context) {
        return null;
    }

    @Override
    public IntegerDistribution getIntegerDistribution(Context context) {
        return null;
    }
}

