/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.calculator.parser;

import edu.cmu.tetrad.calculator.expression.ExpressionDescriptor;
import edu.cmu.tetrad.calculator.expression.ExpressionManager;
import edu.cmu.tetrad.calculator.parser.Token;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionLexer {
    private static Map<Token, Pattern> PATTERNS;
    private final CharSequence charSequence;
    private final Token[] tokens = new Token[]{Token.WHITESPACE, Token.COMMA, Token.LPAREN, Token.NUMBER, Token.OPERATOR, Token.RPAREN, Token.PARAMETER, Token.EQUATION, Token.STRING};
    private int currentOffset;
    private int nextOffset;
    private Map<Token, Matcher> matchers = new HashMap<Token, Matcher>();
    private Matcher lastMatcher;

    public ExpressionLexer(CharSequence seq) {
        if (seq == null) {
            throw new NullPointerException("CharSequence must not be null.");
        }
        if (PATTERNS == null) {
            PATTERNS = ExpressionLexer.createPatterns();
        }
        this.charSequence = seq;
        this.matchers = ExpressionLexer.createMatchers(PATTERNS, seq);
    }

    private static Map<Token, Matcher> createMatchers(Map<Token, Pattern> patterns, CharSequence charSequence) {
        HashMap<Token, Matcher> matchers = new HashMap<Token, Matcher>();
        for (Token token : patterns.keySet()) {
            Pattern pattern = patterns.get((Object)token);
            Matcher matcher = pattern.matcher(charSequence);
            matchers.put(token, matcher);
        }
        return matchers;
    }

    private static Map<Token, Pattern> createPatterns() {
        HashMap<Token, Pattern> map = new HashMap<Token, Pattern>();
        HashMap<Token, String> regex = new HashMap<Token, String>();
        regex.put(Token.WHITESPACE, "\\s+");
        regex.put(Token.LPAREN, "\\(");
        regex.put(Token.RPAREN, "\\)");
        regex.put(Token.COMMA, ",");
        regex.put(Token.NUMBER, "-?[\\d\\.]+(e-?\\d+)?");
        regex.put(Token.OPERATOR, ExpressionLexer.getExpressionRegex());
        regex.put(Token.PARAMETER, "\\$|(([a-zA-Z]{1})([a-zA-Z0-9-_/:\\.]*))");
        regex.put(Token.EQUATION, "\\=");
        regex.put(Token.STRING, "\\\".*\\\"");
        for (Token token : regex.keySet()) {
            map.put(token, Pattern.compile("\\G" + (String)regex.get((Object)token)));
        }
        return map;
    }

    private static String getExpressionRegex() {
        String str = "(";
        List<ExpressionDescriptor> descriptors = ExpressionManager.getInstance().getDescriptors();
        for (int i = 0; i < descriptors.size(); ++i) {
            ExpressionDescriptor exp = descriptors.get(i);
            str = str + "(" + exp.getToken() + ")";
            if (i >= descriptors.size() - 1) continue;
            str = str + "|";
        }
        str = str.replace("+", "\\+");
        str = str.replace("*", "\\*");
        str = str.replace("^", "\\^");
        return str + ")";
    }

    public final Token nextToken() {
        this.readToken(Token.WHITESPACE);
        for (Token token : this.tokens) {
            if (!this.readToken(token)) continue;
            return token;
        }
        if (this.charSequence.length() <= this.nextOffset) {
            return Token.EOF;
        }
        return Token.UNKNOWN;
    }

    public final Token nextTokenIncludingWhitespace() {
        for (Token token : this.tokens) {
            if (!this.readToken(token)) continue;
            return token;
        }
        if (this.charSequence.length() <= this.nextOffset) {
            return Token.EOF;
        }
        return Token.UNKNOWN;
    }

    public String getTokenString() {
        if (this.lastMatcher == null) {
            return null;
        }
        try {
            return this.lastMatcher.group();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public int getNextOffset() {
        return this.nextOffset;
    }

    private boolean readToken(Token token) {
        Matcher matcher = this.matchers.get((Object)token);
        boolean found = matcher.find(this.nextOffset);
        if (found) {
            if (matcher.end() - matcher.group().length() != this.nextOffset) {
                this.currentOffset = this.nextOffset;
                this.nextOffset = matcher.end();
                return false;
            }
            this.currentOffset = this.nextOffset;
            this.nextOffset = matcher.end();
            this.lastMatcher = matcher;
        }
        return found;
    }
}

