/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.calculator.parser;

import edu.cmu.tetrad.calculator.expression.ConstantExpression;
import edu.cmu.tetrad.calculator.expression.Equation;
import edu.cmu.tetrad.calculator.expression.EvaluationExpression;
import edu.cmu.tetrad.calculator.expression.Expression;
import edu.cmu.tetrad.calculator.expression.ExpressionDescriptor;
import edu.cmu.tetrad.calculator.expression.ExpressionInitializationException;
import edu.cmu.tetrad.calculator.expression.ExpressionManager;
import edu.cmu.tetrad.calculator.expression.VariableExpression;
import edu.cmu.tetrad.calculator.parser.ExpressionLexer;
import edu.cmu.tetrad.calculator.parser.Token;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ExpressionParser {
    private final ExpressionManager expressions = ExpressionManager.getInstance();
    private final Set<String> parameters;
    private final Set<String> restrictionParameters;
    private Token token;
    private ExpressionLexer lexer;
    private RestrictionType restrictionType;

    public ExpressionParser() {
        this.restrictionParameters = Collections.emptySet();
        this.parameters = new LinkedHashSet<String>();
    }

    public ExpressionParser(Collection<String> parameters, RestrictionType type) {
        if (parameters == null) {
            throw new NullPointerException("Parameters null.");
        }
        if (parameters.contains("$")) {
            throw new IllegalArgumentException("Variable list must not contain the wildcard '$'.");
        }
        this.restrictionParameters = new LinkedHashSet<String>(parameters);
        this.restrictionParameters.add("$");
        this.parameters = new LinkedHashSet<String>();
        this.restrictionType = type;
    }

    public Expression parseExpression(String expression) throws ParseException {
        this.lexer = new ExpressionLexer(expression);
        this.nextToken();
        Expression exp = this.parseExpression();
        this.expect(Token.EOF);
        return exp;
    }

    public Equation parseEquation(String equation) throws ParseException {
        int index = equation.indexOf("=");
        if (index < 1) {
            throw new ParseException("Equations must be of the form Var = Exp", 0);
        }
        String variable = equation.substring(0, index).trim();
        if (!variable.matches("[^0-9]?[^ \t]*")) {
            throw new ParseException("Invalid variable name.", 1);
        }
        return new Equation(variable, this.parseExpression(equation.substring(index + 1).trim()), equation);
    }

    public int getNextOffset() {
        return this.lexer.getNextOffset();
    }

    private void nextToken() throws ParseException {
        this.token = this.lexer.nextToken();
        if (this.token == Token.UNKNOWN) {
            throw new ParseException("Unrecognized token,", this.lexer.getCurrentOffset());
        }
    }

    private Expression parseExpression() throws ParseException {
        return this.parseAndExpression();
    }

    private Expression parseAndExpression() throws ParseException {
        Expression expression = this.parseOrExpression();
        while (this.token == Token.OPERATOR && "AND".equals(this.lexer.getTokenString())) {
            int offset = this.lexer.getCurrentOffset();
            ExpressionDescriptor descriptor = this.getDescriptor();
            this.nextToken();
            Expression expression2 = this.parseOrExpression();
            try {
                expression = descriptor.createExpression(expression, expression2);
            }
            catch (ExpressionInitializationException e) {
                throw new ParseException("Wrong number of arguments for expression " + descriptor.getName(), offset);
            }
        }
        return expression;
    }

    private Expression parseOrExpression() throws ParseException {
        Expression expression = this.parseXorExpression();
        while (this.token == Token.OPERATOR && "OR".equals(this.lexer.getTokenString())) {
            int offset = this.lexer.getCurrentOffset();
            ExpressionDescriptor descriptor = this.getDescriptor();
            this.nextToken();
            Expression expression2 = this.parseXorExpression();
            try {
                expression = descriptor.createExpression(expression, expression2);
            }
            catch (ExpressionInitializationException e) {
                throw new ParseException("Wrong number of arguments for expression " + descriptor.getName(), offset);
            }
        }
        return expression;
    }

    private Expression parseXorExpression() throws ParseException {
        Expression expression = this.parseComparisonExpression();
        while (this.token == Token.OPERATOR && "XOR".equals(this.lexer.getTokenString())) {
            int offset = this.lexer.getCurrentOffset();
            ExpressionDescriptor descriptor = this.getDescriptor();
            this.nextToken();
            Expression expression2 = this.parsePlusExpression();
            try {
                expression = descriptor.createExpression(expression, expression2);
            }
            catch (ExpressionInitializationException e) {
                throw new ParseException("Wrong number of arguments for expression " + descriptor.getName(), offset);
            }
        }
        return expression;
    }

    private Expression parseComparisonExpression() throws ParseException {
        Expression expression = this.parsePlusExpression();
        HashSet<String> comparisonOperators = new HashSet<String>();
        comparisonOperators.add("<");
        comparisonOperators.add("<=");
        comparisonOperators.add("=");
        comparisonOperators.add(">");
        comparisonOperators.add(">=");
        while (this.token == Token.OPERATOR && comparisonOperators.contains(this.lexer.getTokenString())) {
            int offset = this.lexer.getCurrentOffset();
            ExpressionDescriptor descriptor = this.getDescriptor();
            this.nextToken();
            Expression expression2 = this.parsePlusExpression();
            try {
                expression = descriptor.createExpression(expression, expression2);
            }
            catch (ExpressionInitializationException e) {
                throw new ParseException("Wrong number of arguments for expression " + descriptor.getName(), offset);
            }
        }
        return expression;
    }

    private Expression parsePlusExpression() throws ParseException {
        Expression expression = this.parseMultDivExpression();
        while (this.token == Token.OPERATOR && "+".equals(this.lexer.getTokenString()) || "-".equals(this.lexer.getTokenString())) {
            int offset = this.lexer.getCurrentOffset();
            ExpressionDescriptor descriptor = this.getDescriptor();
            this.nextToken();
            Expression expression2 = this.parseMultDivExpression();
            try {
                expression = descriptor.createExpression(expression, expression2);
            }
            catch (ExpressionInitializationException e) {
                throw new ParseException("Wrong number of arguments for expression " + descriptor.getName(), offset);
            }
        }
        return expression;
    }

    private Expression parseMultDivExpression() throws ParseException {
        Expression expression = this.parsePowerExpression();
        while (this.token == Token.OPERATOR && "*".equals(this.lexer.getTokenString()) || "/".equals(this.lexer.getTokenString())) {
            int offset = this.lexer.getCurrentOffset();
            ExpressionDescriptor descriptor = this.getDescriptor();
            this.nextToken();
            Expression expression2 = this.parsePowerExpression();
            try {
                expression = descriptor.createExpression(expression, expression2);
            }
            catch (ExpressionInitializationException e) {
                throw new ParseException("Wrong number of arguments for expression " + descriptor.getName(), offset);
            }
        }
        return expression;
    }

    private Expression parsePowerExpression() throws ParseException {
        Expression expression = this.parseChompExpression();
        while (this.token == Token.OPERATOR && "^".equals(this.lexer.getTokenString())) {
            int offset = this.lexer.getCurrentOffset();
            ExpressionDescriptor descriptor = this.getDescriptor();
            this.nextToken();
            Expression expression2 = this.parseChompExpression();
            try {
                expression = descriptor.createExpression(expression, expression2);
            }
            catch (ExpressionInitializationException e) {
                throw new ParseException("Wrong number of arguments for expression " + descriptor.getName(), offset);
            }
        }
        return expression;
    }

    private Expression parseChompExpression() throws ParseException {
        int chompOffset = this.lexer.getCurrentOffset();
        String chompTokenString = this.lexer.getTokenString();
        if (this.token == Token.NUMBER) {
            String numberString = this.lexer.getTokenString();
            ConstantExpression exp = new ConstantExpression(this.convertNumber(numberString));
            this.nextToken();
            return exp;
        }
        if (this.token == Token.PARAMETER) {
            if (this.lexer.getTokenString().equals("pi") || this.lexer.getTokenString().equals("PI")) {
                this.nextToken();
                return ConstantExpression.PI;
            }
            if (this.lexer.getTokenString().equals("e") || this.lexer.getTokenString().equals("E")) {
                this.nextToken();
                return ConstantExpression.E;
            }
            String stringToken = this.lexer.getTokenString();
            if (this.getRestrictionType() == RestrictionType.MAY_ONLY_CONTAIN) {
                if (!this.restrictionParameters.contains(stringToken)) {
                    throw new ParseException("Variable " + stringToken + " is not known.", chompOffset);
                }
            } else if (this.getRestrictionType() == RestrictionType.MAY_NOT_CONTAIN && this.restrictionParameters.contains(stringToken)) {
                throw new ParseException("Variable " + stringToken + " may not be used in this expression.", chompOffset);
            }
            this.parameters.add(stringToken);
            VariableExpression exp = new VariableExpression(stringToken);
            this.nextToken();
            if (this.token == Token.EQUATION) {
                return this.parseEvaluation(exp);
            }
            return exp;
        }
        if (this.token == Token.OPERATOR) {
            Expression[] expressions;
            ExpressionDescriptor descriptor = this.getDescriptor();
            this.nextToken();
            if (this.token == Token.LPAREN) {
                this.nextToken();
                if (this.token == Token.RPAREN) {
                    this.nextToken();
                    expressions = new Expression[]{};
                } else {
                    List<Expression> expressionList = this.parseExpressionList();
                    this.expect(Token.RPAREN);
                    expressions = expressionList.toArray(new Expression[0]);
                }
            } else if ("+".equals(chompTokenString) || "-".equals(chompTokenString)) {
                List<Expression> expressionList = this.parseSingleExpression();
                expressions = expressionList.toArray(new Expression[0]);
            } else {
                throw new ParseException("Expecting a parenthesized list of arguments.", chompOffset);
            }
            try {
                return descriptor.createExpression(expressions);
            }
            catch (ExpressionInitializationException e) {
                throw new ParseException("Wrong number of arguments: " + expressions.length + " " + (Object)((Object)this.token), chompOffset);
            }
        }
        if (this.token == Token.LPAREN) {
            this.nextToken();
            Expression exp = this.parseExpression();
            this.expect(Token.RPAREN);
            return exp;
        }
        throw new ParseException("Unexpected token: " + this.lexer.getTokenString(), this.lexer.getCurrentOffset());
    }

    private Expression parseEvaluation(VariableExpression variable) throws ParseException {
        this.expect(Token.EQUATION);
        if (this.token != Token.STRING) {
            throw new ParseException("Evaluations must be of the form Var = String", this.lexer.getCurrentOffset());
        }
        String s = this.lexer.getTokenString();
        this.nextToken();
        return new EvaluationExpression(variable, s.replace("\"", ""));
    }

    private List<Expression> parseExpressionList() throws ParseException {
        LinkedList<Expression> expressions = new LinkedList<Expression>();
        expressions.add(this.parseExpression());
        while (this.token == Token.COMMA) {
            this.nextToken();
            expressions.add(this.parseExpression());
        }
        return expressions;
    }

    private List<Expression> parseSingleExpression() throws ParseException {
        LinkedList<Expression> expressions = new LinkedList<Expression>();
        expressions.add(this.parseExpression());
        return expressions;
    }

    private double convertNumber(String number) throws ParseException {
        try {
            return Double.parseDouble(number);
        }
        catch (Exception ex) {
            throw new ParseException("Not a number: " + number + ".", this.lexer.getCurrentOffset());
        }
    }

    private ExpressionDescriptor getDescriptor() throws ParseException {
        String tokenString = this.lexer.getTokenString();
        ExpressionDescriptor descriptor = this.expressions.getDescriptorFromToken(tokenString);
        if (descriptor == null) {
            throw new ParseException("Not a function name: " + tokenString, this.lexer.getCurrentOffset());
        }
        return descriptor;
    }

    private void expect(Token token) throws ParseException {
        if (token != this.token) {
            throw new ParseException("Unexpected token: " + this.getTokenString(), this.lexer.getCurrentOffset());
        }
        this.nextToken();
    }

    private RestrictionType getRestrictionType() {
        return this.restrictionType;
    }

    public List<String> getParameters() {
        return new LinkedList<String>(this.parameters);
    }

    private String getTokenString() {
        return this.lexer.getTokenString();
    }

    public static enum RestrictionType {
        MAY_ONLY_CONTAIN,
        MAY_NOT_CONTAIN,
        NONE;

    }
}

