/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.Variable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NamingProtocol;

public abstract class AbstractVariable
implements Variable {
    private static final long serialVersionUID = 23L;
    public static int LAST_ID;
    private String name;

    AbstractVariable(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name = name.trim();
    }

    @Override
    public abstract Object getMissingValueMarker();

    @Override
    public abstract boolean isMissingValue(Object var1);

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("AbstractVariable name must not be null.");
        }
        if (!NamingProtocol.isLegalName(name)) {
            throw new IllegalArgumentException(NamingProtocol.getProtocolDescription());
        }
        this.name = name;
    }

    @Override
    public boolean checkValue(Object value) {
        return true;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public abstract Node like(String var1);
}

