/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

public class AndersonDarlingTest {
    private final double[] data;
    private double aSquared;
    private double aSquaredStar;
    private double p;

    public AndersonDarlingTest(double[] data) {
        this.data = data;
        this.runTest();
    }

    public double getASquared() {
        return this.aSquared;
    }

    public double getASquaredStar() {
        return this.aSquaredStar;
    }

    public double getP() {
        return this.p;
    }

    private void runTest() {
        double[] x = this.leaveOutNanAndInfinite(this.data);
        int n = x.length;
        Arrays.sort(x);
        double mean = StatUtils.mean(x);
        double sd = StatUtils.sd(x);
        for (int i = 0; i < n; ++i) {
            x[i] = (x[i] - mean) / sd;
        }
        double h = 0.0;
        int numSummed = 0;
        for (int i = 1; i <= n; ++i) {
            double x1 = x[i - 1];
            double a1 = FastMath.log(RandomUtil.getInstance().normalCdf(0.0, 1.0, x1));
            double x2 = x[n + 1 - i - 1];
            double a2 = FastMath.log(1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, x2));
            double k = (double)(2 * i - 1) * (a1 + a2);
            if (Double.isNaN(a1) || Double.isNaN(a2) || Double.isInfinite(a1) || Double.isInfinite(a2)) continue;
            h += k;
            ++numSummed;
        }
        double a = (double)(-numSummed) - 1.0 / (double)numSummed * h;
        double aa = (1.0 + 0.75 / (double)numSummed + 2.25 / FastMath.pow((double)numSummed, 2)) * a;
        double p = aa < 0.2 ? 1.0 - FastMath.exp(-13.436 + 101.14 * aa - 223.73 * aa * aa) : (aa < 0.34 ? 1.0 - FastMath.exp(-8.318 + 42.796 * aa - 59.938 * aa * aa) : (aa < 0.6 ? FastMath.exp(0.9177 - 4.279 * aa - 1.38 * aa * aa) : FastMath.exp(1.2937 - 5.709 * aa + 0.0186 * aa * aa)));
        this.aSquared = a;
        this.aSquaredStar = aa;
        this.p = p;
    }

    private double[] leaveOutNanAndInfinite(double[] data) {
        int numPresent = 0;
        for (double aData1 : data) {
            if (Double.isNaN(aData1) || Double.isInfinite(aData1)) continue;
            ++numPresent;
        }
        if (numPresent == data.length) {
            double[] _data = new double[data.length];
            System.arraycopy(data, 0, _data, 0, data.length);
            return _data;
        }
        ArrayList<Double> _leaveOutMissing = new ArrayList<Double>();
        for (double aData : data) {
            if (Double.isNaN(aData) || Double.isInfinite(aData)) continue;
            _leaveOutMissing.add(aData);
        }
        double[] _data = new double[_leaveOutMissing.size()];
        for (int i = 0; i < _leaveOutMissing.size(); ++i) {
            _data[i] = (Double)_leaveOutMissing.get(i);
        }
        return _data;
    }
}

