/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.HashSet;

public final class BootstrapSampler {
    private boolean withoutReplacements;

    public DataSet sample(DataSet dataSet, int newSampleSize) {
        if (newSampleSize < 1) {
            throw new IllegalArgumentException("Sample size must be > 0.");
        }
        if (dataSet.getNumRows() < 1) {
            throw new IllegalArgumentException("Dataset must contain samples.");
        }
        int oldSampleSize = dataSet.getNumRows();
        int ncols = dataSet.getNumColumns();
        BoxDataSet newDataSet = new BoxDataSet(new VerticalDoubleDataBox(newSampleSize, dataSet.getVariables().size()), dataSet.getVariables());
        HashSet<Integer> oldCases = new HashSet<Integer>();
        for (int row = 0; row < newSampleSize; ++row) {
            int oldCase = RandomUtil.getInstance().nextInt(oldSampleSize);
            if (this.isWithoutReplacements()) {
                if (oldCases.contains(oldCase)) {
                    --row;
                    continue;
                }
                oldCases.add(oldCase);
            }
            for (int col = 0; col < ncols; ++col) {
                newDataSet.setObject(row, col, dataSet.getObject(oldCase, col));
            }
        }
        newDataSet.setKnowledge(dataSet.getKnowledge().copy());
        return newDataSet;
    }

    public boolean isWithoutReplacements() {
        return this.withoutReplacements;
    }

    public void setWithoutReplacements(boolean withoutReplacements) {
        this.withoutReplacements = withoutReplacements;
    }
}

