/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataBox;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.MixedDataBox;
import edu.cmu.tetrad.data.ShortDataBox;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BoxDataSet
implements DataSet {
    private static final long serialVersionUID = 23L;
    private final Map<Integer, String> caseIds = new HashMap<Integer, String>();
    private Map<String, String> columnToTooltip;
    private String name = "";
    private List<Node> variables;
    private DataBox dataBox;
    private Set<Node> selection = new HashSet<Node>();
    private Map<Integer, Integer> multipliers = new HashMap<Integer, Integer>();
    private Knowledge knowledge = new Knowledge();
    private transient NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private char outputDelimiter = (char)9;

    public BoxDataSet(DataBox dataBox, List<Node> variables) {
        this.dataBox = dataBox;
        this.variables = new ArrayList<Node>(variables);
        if (dataBox.numCols() != variables.size()) {
            throw new IllegalArgumentException("Number of columns must match the number of variables.");
        }
    }

    public BoxDataSet(BoxDataSet dataSet) {
        this.name = dataSet.name;
        this.variables = new LinkedList<Node>(dataSet.variables);
        this.dataBox = dataSet.dataBox.copy();
        this.selection = new HashSet<Node>(dataSet.selection);
        this.multipliers = new HashMap<Integer, Integer>(dataSet.multipliers);
        this.knowledge = dataSet.knowledge.copy();
    }

    public static BoxDataSet serializableInstance() {
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < 4; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        return new BoxDataSet(new ShortDataBox(4, 4), vars);
    }

    private static void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    private static double getValueFromObjectContinuous(Object element) {
        if ("*".equals(element) || "".equals(element)) {
            return ContinuousVariable.getDoubleMissingValue();
        }
        if (element instanceof Number) {
            return ((Number)element).doubleValue();
        }
        if (element instanceof String) {
            try {
                return Double.parseDouble((String)element);
            }
            catch (NumberFormatException e) {
                return ContinuousVariable.getDoubleMissingValue();
            }
        }
        throw new IllegalArgumentException("The argument 'element' must be either a Number or a String.");
    }

    @Override
    public Map<String, String> getColumnToTooltip() {
        return this.columnToTooltip;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name;
    }

    @Override
    public int getNumColumns() {
        return this.variables.size();
    }

    @Override
    public int getNumRows() {
        return this.dataBox.numRows();
    }

    @Override
    public void setInt(int row, int column, int value) {
        block7: {
            this.ensureRows(row + 1);
            Node variable = this.getVariable(column);
            if (!(variable instanceof DiscreteVariable)) {
                throw new IllegalArgumentException("Can only set ints for discrete columns.");
            }
            DiscreteVariable _variable = (DiscreteVariable)variable;
            if (value < 0 && value != -99) {
                throw new IllegalArgumentException("Value must be a positive integer: " + value);
            }
            if (value >= _variable.getNumCategories()) {
                if (_variable.isAccommodateNewCategories()) {
                    this.accomodateIndex(_variable, value);
                } else {
                    throw new IllegalArgumentException("Not a value for that variable: " + value);
                }
            }
            try {
                this.setIntPrivate(row, column, value);
            }
            catch (Exception e) {
                if (row >= 0 && column >= 0 && row < this.getNumRows() && column < this.getNumColumns()) break block7;
                throw new IllegalArgumentException("Row or columns out of range.");
            }
        }
    }

    @Override
    public void setDouble(int row, int column, double value) {
        block2: {
            this.ensureRows(row + 1);
            try {
                this.dataBox.set(row, column, value);
            }
            catch (Exception e) {
                if (row >= 0 && column >= 0 && row < this.getNumRows() && column < this.getNumColumns()) break block2;
                throw new IllegalArgumentException("Row or columns out of range.");
            }
        }
    }

    @Override
    public Object getObject(int row, int col) {
        Node variable = this.getVariable(col);
        if (variable instanceof ContinuousVariable) {
            return this.getDouble(row, col);
        }
        if (variable instanceof DiscreteVariable) {
            DiscreteVariable _variable = (DiscreteVariable)variable;
            if (_variable.isCategoryNamesDisplayed()) {
                return _variable.getCategory(this.getInt(row, col));
            }
            return this.getInt(row, col);
        }
        throw new IllegalArgumentException("Not a row/col in this data set: " + row + ", " + col);
    }

    @Override
    public void setObject(int row, int col, Object value) {
        Node variable = this.getVariable(col);
        if (variable instanceof ContinuousVariable) {
            this.setDouble(row, col, BoxDataSet.getValueFromObjectContinuous(value));
        } else if (variable instanceof DiscreteVariable) {
            this.setInt(row, col, this.getValueFromObjectDiscrete(value, (DiscreteVariable)variable));
        } else {
            throw new IllegalArgumentException("Expecting either a continuous or a discrete variable.");
        }
    }

    @Override
    public int[] getSelectedIndices() {
        List<Node> variables = this.getVariables();
        Set<Node> selection = this.getSelection();
        int[] indices = new int[selection.size()];
        int j = -1;
        for (int i = 0; i < variables.size(); ++i) {
            if (!selection.contains(variables.get(i))) continue;
            indices[++j] = i;
        }
        return indices;
    }

    @Override
    public void addVariable(Node variable) {
        if (this.variables.contains(variable)) {
            throw new IllegalArgumentException("Expecting a new variable: " + variable);
        }
        try {
            this.variables.add(variable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resize(this.dataBox.numRows(), this.variables.size());
        int col = this.dataBox.numCols() - 1;
        for (int i = 0; i < this.dataBox.numRows(); ++i) {
            this.dataBox.set(i, col, null);
        }
    }

    @Override
    public void addVariable(int index, Node variable) {
        if (this.variables.contains(variable)) {
            throw new IllegalArgumentException("Expecting a new variable.");
        }
        if (index < 0 || index > this.variables.size()) {
            throw new IndexOutOfBoundsException("Index must in (0, #vars).");
        }
        this.variables.add(index, variable);
        this.resize(this.dataBox.numRows(), this.variables.size());
        Number[][] _data = new Number[this.dataBox.numRows()][this.dataBox.numCols()];
        for (int j = 0; j < this.dataBox.numCols(); ++j) {
            int i;
            if (j < index) {
                for (i = 0; i < this.dataBox.numRows(); ++i) {
                    _data[i][j] = this.dataBox.get(i, j);
                }
                continue;
            }
            if (j == index) {
                for (i = 0; i < this.dataBox.numRows(); ++i) {
                    _data[i][j] = null;
                }
                continue;
            }
            for (i = 0; i < this.dataBox.numRows(); ++i) {
                _data[i][j] = this.dataBox.get(i, j - 1);
            }
        }
    }

    @Override
    public Node getVariable(int col) {
        return this.variables.get(col);
    }

    @Override
    public int getColumn(Node variable) {
        return this.variables.indexOf(variable);
    }

    @Override
    public void changeVariable(Node from, Node to) {
        int i;
        if (!(from instanceof DiscreteVariable) || !(to instanceof DiscreteVariable)) {
            throw new IllegalArgumentException("Only discrete variables supported.");
        }
        DiscreteVariable _from = (DiscreteVariable)from;
        DiscreteVariable _to = (DiscreteVariable)to;
        int col = this.variables.indexOf(_from);
        List<String> oldCategories = _from.getCategories();
        List<String> newCategories = _to.getCategories();
        int[] indexArray = new int[oldCategories.size()];
        for (i = 0; i < oldCategories.size(); ++i) {
            indexArray[i] = newCategories.indexOf(oldCategories.get(i));
        }
        for (i = 0; i < this.getNumRows() && this.dataBox.get(i, col) != null; ++i) {
            int value = this.getInt(i, col);
            int newIndex = 0;
            try {
                newIndex = indexArray[value];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newIndex == -1) {
                this.dataBox.set(i, col, null);
                continue;
            }
            this.setInt(i, col, newIndex);
        }
        this.variables.set(col, _to);
    }

    @Override
    public Node getVariable(String varName) {
        for (Node variable1 : this.variables) {
            if (!variable1.getName().equals(varName)) continue;
            return variable1;
        }
        return null;
    }

    @Override
    public List<Node> getVariables() {
        return new LinkedList<Node>(this.variables);
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge.copy();
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge.copy();
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> vars = this.getVariables();
        ArrayList<String> names = new ArrayList<String>();
        for (Node variable : vars) {
            String name = variable.getName();
            names.add(name);
        }
        return names;
    }

    @Override
    public void setSelected(Node variable, boolean selected) {
        if (selected) {
            if (this.variables.contains(variable)) {
                this.getSelection().add(variable);
            }
        } else if (this.variables.contains(variable)) {
            this.getSelection().remove(variable);
        }
    }

    @Override
    public void clearSelection() {
        this.getSelection().clear();
    }

    @Override
    public void ensureRows(int rows) {
        if (rows > this.getNumRows()) {
            this.resize(rows, this.getNumColumns());
        }
    }

    @Override
    public void ensureColumns(int columns, List<String> excludedVariableNames) {
        for (int col = this.getNumColumns(); col < columns; ++col) {
            String _name;
            int i = 0;
            while (this.getVariable(_name = "X" + ++i) != null || excludedVariableNames.contains(_name)) {
            }
            ContinuousVariable variable = new ContinuousVariable(_name);
            this.addVariable(variable);
            this.resize(this.getNumRows(), this.getNumColumns());
        }
    }

    @Override
    public boolean existsMissingValue() {
        for (int i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                if (this.variables.get(j) instanceof ContinuousVariable && Double.isNaN(this.getDouble(i, j))) {
                    return true;
                }
                if (!(this.variables.get(j) instanceof DiscreteVariable) || this.getInt(i, j) != -99) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSelected(Node variable) {
        return this.getSelection().contains(variable);
    }

    @Override
    public void removeColumn(int index) {
        if (index < 0 || index >= this.variables.size()) {
            throw new IllegalArgumentException("Not a column in this data set: " + index);
        }
        this.variables.remove(index);
        int[] rows = new int[this.dataBox.numRows()];
        for (int i = 0; i < this.dataBox.numRows(); ++i) {
            rows[i] = i;
        }
        int[] cols = new int[this.dataBox.numCols() - 1];
        int m = -1;
        for (int i = 0; i < this.dataBox.numCols(); ++i) {
            if (i == index) continue;
            cols[++m] = i;
        }
        this.dataBox = this.viewSelection(rows, cols);
    }

    private DataBox viewSelection(int[] rows, int[] cols) {
        return this.dataBox.viewSelection(rows, cols);
    }

    @Override
    public void removeColumn(Node variable) {
        int index = this.variables.indexOf(variable);
        if (index != -1) {
            this.removeColumn(index);
        }
    }

    @Override
    public DataSet subsetColumns(List<Node> vars) {
        if (!this.getVariables().containsAll(vars)) {
            ArrayList<Node> missingVars = new ArrayList<Node>(vars);
            missingVars.removeAll(this.getVariables());
            throw new IllegalArgumentException("All vars must be original vars: " + missingVars);
        }
        int[] rows = new int[this.dataBox.numRows()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        int[] cols = new int[vars.size()];
        for (int j = 0; j < cols.length; ++j) {
            cols[j] = this.getVariables().indexOf(vars.get(j));
        }
        DataBox _dataBox = this.viewSelection(rows, cols);
        BoxDataSet _dataSet = new BoxDataSet(_dataBox, vars);
        _dataSet.variables = vars;
        _dataSet.selection = new HashSet<Node>();
        _dataSet.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        _dataSet.knowledge = this.knowledge.copy();
        return _dataSet;
    }

    @Override
    public boolean isContinuous() {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Node variable = this.variables.get(i);
            if (variable instanceof ContinuousVariable) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDiscrete() {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Node column = this.variables.get(i);
            if (column instanceof DiscreteVariable) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMixed() {
        int numContinuous = 0;
        int numDiscrete = 0;
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Node column = this.variables.get(i);
            if (column instanceof ContinuousVariable) {
                ++numContinuous;
                continue;
            }
            if (column instanceof DiscreteVariable) {
                ++numDiscrete;
                continue;
            }
            throw new IllegalArgumentException("Column not of type continuousor of type discrete; can't classify this data set.");
        }
        return numContinuous > 0 && numDiscrete > 0;
    }

    @Override
    public Matrix getCorrelationMatrix() {
        if (!this.isContinuous()) {
            throw new IllegalStateException("Not a continuous data set.");
        }
        return MatrixUtils.convertCovToCorr(this.getCovarianceMatrix());
    }

    @Override
    public Matrix getCovarianceMatrix() {
        if (!this.isContinuous()) {
            throw new IllegalStateException("Not a continuous data set.");
        }
        if (this.getNumColumns() == 0) {
            return new Matrix(0, 0);
        }
        return new CovarianceMatrix(this).getMatrix();
    }

    @Override
    public int getInt(int row, int column) {
        Number value = this.dataBox.get(row, column);
        if (value == null) {
            return -99;
        }
        return value.intValue();
    }

    @Override
    public double getDouble(int row, int column) {
        Number value = this.dataBox.get(row, column);
        if (value == null) {
            return ContinuousVariable.getDoubleMissingValue();
        }
        return value.doubleValue();
    }

    @Override
    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        List<Node> variables = this.getVariables();
        buf.append("\n");
        for (i = 0; i < this.getNumColumns(); ++i) {
            buf.append(variables.get(i));
            if (i >= this.getNumColumns() - 1) continue;
            buf.append(this.outputDelimiter);
        }
        buf.append("\n");
        for (i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                Node variable = this.getVariable(j);
                if (variable instanceof ContinuousVariable) {
                    if (Double.isNaN(this.getDouble(i, j))) {
                        buf.append("*");
                    } else {
                        buf.append(this.getNumberFormat().format(this.getDouble(i, j)));
                    }
                    if (j >= this.getNumColumns() - 1) continue;
                    buf.append(this.outputDelimiter);
                    continue;
                }
                if (variable instanceof DiscreteVariable) {
                    DiscreteVariable _variable = (DiscreteVariable)variable;
                    int value = this.getInt(i, j);
                    if (value == -99) {
                        buf.append("*");
                    } else {
                        String category = _variable.getCategory(value);
                        if (category.indexOf(this.outputDelimiter) == -1) {
                            buf.append(category);
                        } else {
                            buf.append("\"").append(category).append("\"");
                        }
                    }
                    if (j >= this.getNumColumns() - 1) continue;
                    buf.append(this.outputDelimiter);
                    continue;
                }
                throw new IllegalStateException("Expecting either a continuous variable or a discrete variable: variable = " + variable + " type = " + variable.getClass());
            }
            buf.append("\n");
        }
        buf.append("\n");
        if (this.knowledge != null && !this.knowledge.isEmpty()) {
            buf.append(this.knowledge);
        }
        return buf.toString();
    }

    @Override
    public Matrix getDoubleData() {
        Matrix copy = new Matrix(this.dataBox.numRows(), this.dataBox.numCols());
        for (int i = 0; i < this.dataBox.numRows(); ++i) {
            for (int j = 0; j < this.dataBox.numCols(); ++j) {
                Number number = this.dataBox.get(i, j);
                if (number == null) {
                    copy.set(i, j, Double.NaN);
                    continue;
                }
                copy.set(i, j, number.doubleValue());
            }
        }
        return copy;
    }

    @Override
    public DataSet subsetColumns(int[] indices) {
        List<Node> variables = this.getVariables();
        LinkedList<Node> _variables = new LinkedList<Node>();
        for (int index : indices) {
            _variables.add(variables.get(index));
        }
        int[] rows = new int[this.dataBox.numRows()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        DataBox _data = this.viewSelection(rows, indices);
        BoxDataSet _dataSet = new BoxDataSet(_data, _variables);
        _dataSet.name = this.name;
        _dataSet.variables = _variables;
        _dataSet.selection = new HashSet<Node>();
        _dataSet.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        _dataSet.knowledge = this.knowledge.copy();
        return _dataSet;
    }

    @Override
    public DataSet subsetRows(int[] rows) {
        int[] cols = new int[this.dataBox.numCols()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = i;
        }
        DataBox newBox = this.dataBox.viewSelection(rows, cols);
        BoxDataSet _data = new BoxDataSet(this);
        _data.dataBox = newBox;
        return _data;
    }

    @Override
    public DataSet subsetRowsColumns(int[] rows, int[] columns) {
        List<Node> variables = this.getVariables();
        LinkedList<Node> _variables = new LinkedList<Node>();
        for (int index : columns) {
            _variables.add(variables.get(index));
        }
        DataBox _data = this.viewSelection(rows, columns);
        BoxDataSet _dataSet = new BoxDataSet(_data, _variables);
        _dataSet.name = this.name;
        _dataSet.variables = _variables;
        _dataSet.selection = new HashSet<Node>();
        _dataSet.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        _dataSet.knowledge = this.knowledge.copy();
        return _dataSet;
    }

    @Override
    public void removeCols(int[] cols) {
        int[] rows = new int[this.dataBox.numRows()];
        for (int i = 0; i < this.dataBox.numRows(); ++i) {
            rows[i] = i;
        }
        int[] retainedCols = new int[this.variables.size() - cols.length];
        int i = -1;
        for (int j = 0; j < this.variables.size(); ++j) {
            if (Arrays.binarySearch(cols, j) >= 0) continue;
            retainedCols[++i] = j;
        }
        LinkedList<Node> retainedVars = new LinkedList<Node>();
        for (int retainedCol : retainedCols) {
            retainedVars.add(this.variables.get(retainedCol));
        }
        this.dataBox = this.viewSelection(rows, retainedCols);
        this.variables = retainedVars;
        this.selection = new HashSet<Node>();
        this.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        this.knowledge = this.knowledge.copy();
    }

    @Override
    public void removeRows(int[] selectedRows) {
        int[] cols = new int[this.dataBox.numCols()];
        for (int i = 0; i < this.dataBox.numCols(); ++i) {
            cols[i] = i;
        }
        int[] retainedRows = new int[this.dataBox.numRows() - selectedRows.length];
        int i = -1;
        for (int j = 0; j < this.dataBox.numRows(); ++j) {
            if (Arrays.binarySearch(selectedRows, j) >= 0) continue;
            retainedRows[++i] = j;
        }
        this.dataBox = this.viewSelection(retainedRows, cols);
        this.selection = new HashSet<Node>();
        this.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        this.knowledge = this.knowledge.copy();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BoxDataSet)) {
            return false;
        }
        BoxDataSet otherDataSet = (BoxDataSet)obj;
        if (this.getNumColumns() != otherDataSet.getNumColumns()) {
            return false;
        }
        if (this.getNumRows() != otherDataSet.getNumRows()) {
            return false;
        }
        if (!this.getVariables().equals(otherDataSet.getVariables())) {
            return false;
        }
        Node[] nodes = this.getVariables().toArray(new Node[0]);
        for (int i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                Node variable = nodes[j];
                double val = this.getDouble(i, j);
                double otherVal = otherDataSet.getDouble(i, j);
                if (variable instanceof ContinuousVariable) {
                    if (Double.isNaN(val) ^ Double.isNaN(otherVal)) {
                        return false;
                    }
                    if (Double.isNaN(val) && Double.isNaN(otherVal) || Double.compare(Double.parseDouble(this.nf.format(val)), Double.parseDouble(this.nf.format(otherVal))) == 0) continue;
                    return false;
                }
                if (val == otherVal) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public DataSet copy() {
        return new BoxDataSet(this);
    }

    @Override
    public DataSet like() {
        return new BoxDataSet(this.dataBox.like(), this.variables);
    }

    @Override
    public void setOutputDelimiter(Character character) {
        this.outputDelimiter = character.charValue();
    }

    @Override
    public void permuteRows() {
        ArrayList<Integer> permutation = new ArrayList<Integer>();
        for (int i = 0; i < this.getNumRows(); ++i) {
            permutation.add(i);
        }
        RandomUtil.shuffle(permutation);
        DataBox data2 = this.dataBox.like();
        for (int i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                data2.set(i, j, this.dataBox.get((Integer)permutation.get(i), j));
            }
        }
        this.dataBox = data2;
    }

    private void setIntPrivate(int row, int col, int value) {
        this.dataBox.set(row, col, value);
    }

    private void resize(int rows, int cols) {
        MixedDataBox newBox = new MixedDataBox(this.variables, rows);
        for (int j = 0; j < cols; ++j) {
            for (int i = 0; i < rows; ++i) {
                if (i >= this.dataBox.numRows() || j >= this.dataBox.numCols()) continue;
                newBox.set(i, j, this.dataBox.get(i, j));
            }
        }
        this.dataBox = newBox;
    }

    private Set<Node> getSelection() {
        if (this.selection == null) {
            this.selection = new HashSet<Node>();
        }
        return this.selection;
    }

    private int getValueFromObjectDiscrete(Object element, DiscreteVariable variable) {
        if ("*".equals(element) || "".equals(element)) {
            return -99;
        }
        if (variable.isAccommodateNewCategories()) {
            if (element instanceof Number) {
                int index = ((Number)element).intValue();
                if (!variable.checkValue(index)) {
                    if (index >= variable.getNumCategories()) {
                        this.accomodateIndex(variable, index);
                    } else {
                        throw new IllegalArgumentException("Variable " + variable + " is not accepting new categories. Problem category is .");
                    }
                }
                return index;
            }
            if (element instanceof String) {
                String label = (String)element;
                int index = (variable = this.accomodateCategory(variable, label)).getIndex(label);
                if (index == -1) {
                    throw new IllegalArgumentException("Not a category for this variable: -1");
                }
                return index;
            }
            throw new IllegalArgumentException("The argument 'element' must be either a Number or a String.");
        }
        if (element instanceof Number) {
            int index = ((Number)element).intValue();
            if (!variable.checkValue(index)) {
                return -99;
            }
            return index;
        }
        if (element instanceof String) {
            String label = (String)element;
            int index = variable.getIndex(label);
            if (index == -1) {
                return -99;
            }
            return index;
        }
        throw new IllegalArgumentException("The argument 'element' must be either a Number or a String.");
    }

    private DiscreteVariable accomodateCategory(DiscreteVariable variable, String category) {
        if (category == null) {
            throw new NullPointerException();
        }
        List<String> categories = variable.getCategories();
        if (!categories.contains(category)) {
            LinkedList<String> newCategories = new LinkedList<String>(categories);
            newCategories.add(category);
            DiscreteVariable newVariable = new DiscreteVariable(variable.getName(), newCategories);
            this.changeVariable(variable, newVariable);
            return newVariable;
        }
        return variable;
    }

    private void accomodateIndex(DiscreteVariable variable, int index) {
        if (!variable.isAccommodateNewCategories()) {
            throw new IllegalArgumentException("This variable is not set to accomodate new categories.");
        }
        if (index >= variable.getNumCategories()) {
            this.adjustCategories(variable, index + 1);
        }
    }

    private void adjustCategories(DiscreteVariable variable, int numCategories) {
        LinkedList<String> categories = new LinkedList<String>(variable.getCategories());
        LinkedList<String> newCategories = new LinkedList<String>(categories);
        if (categories.size() > numCategories) {
            if (variable.getCategories().size() > 0) {
                newCategories.subList(0, variable.getCategories().size()).clear();
            }
        } else if (categories.size() < numCategories) {
            for (int i = categories.size(); i < numCategories; ++i) {
                String category = DataUtils.defaultCategory(i);
                if (categories.contains(category)) continue;
                newCategories.add(category);
            }
        }
        DiscreteVariable to = new DiscreteVariable(variable.getName(), newCategories);
        this.changeVariable(variable, to);
    }

    @Override
    public NumberFormat getNumberFormat() {
        if (this.nf == null) {
            this.nf = NumberFormatUtil.getInstance().getNumberFormat();
        }
        return this.nf;
    }

    @Override
    public void setNumberFormat(NumberFormat nf) {
        if (nf == null) {
            throw new NullPointerException();
        }
        this.nf = nf;
    }

    public DataBox getDataBox() {
        return this.dataBox;
    }
}

