/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.util.MultiDimIntTable;
import java.util.Arrays;

public final class CellTable {
    private final MultiDimIntTable table;
    private int missingValue = -99;

    public CellTable(int[] dims) {
        this.table = new MultiDimIntTable(dims);
    }

    public void addToTable(DataSet dataSet, int[] indices) {
        int[] dims = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            DiscreteVariable variable = (DiscreteVariable)dataSet.getVariable(indices[i]);
            dims[i] = variable.getNumCategories();
        }
        this.table.reset(dims);
        int[] coords = new int[indices.length];
        block3: for (int i = 0; i < dataSet.getNumRows(); ++i) {
            for (int j = 0; j < indices.length; ++j) {
                try {
                    coords[j] = dataSet.getInt(i, indices[j]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    coords[j] = dataSet.getInt(i, j);
                }
                if (coords[j] == this.getMissingValue()) continue block3;
            }
            this.table.increment(coords, 1);
        }
    }

    public int getNumValues(int varIndex) {
        return this.table.getDims(varIndex);
    }

    public long calcMargin(int[] coords) {
        int[] coordCopy = this.internalCoordCopy(coords);
        int sum = 0;
        int i = -1;
        while (++i < coordCopy.length) {
            if (coordCopy[i] != -1) continue;
            int j = 0;
            while (j < this.table.getDimension(i)) {
                coordCopy[i] = j++;
                sum = (int)((long)sum + this.calcMargin(coordCopy));
            }
            coordCopy[i] = -1;
            return sum;
        }
        return this.table.getValue(coordCopy);
    }

    public long calcMargin(int[] coords, int[] marginVars) {
        int[] coordCopy = this.internalCoordCopy(coords);
        for (int marginVar : marginVars) {
            coordCopy[marginVar] = -1;
        }
        return this.calcMargin(coordCopy);
    }

    private int[] internalCoordCopy(int[] coords) {
        int[] coordCopy = Arrays.copyOf(coords, coords.length);
        return coordCopy;
    }

    private int getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(int missingValue) {
        this.missingValue = missingValue;
    }

    public long getValue(int[] testCell) {
        return this.table.getValue(testCell);
    }
}

