/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.MatrixUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public final class CorrelationMatrix
extends CovarianceMatrix {
    private static final long serialVersionUID = 23L;

    public CorrelationMatrix(ICovarianceMatrix matrix) {
        this(matrix.getVariables(), MatrixUtils.convertCovToCorr(matrix.getMatrix()), matrix.getSampleSize());
    }

    public CorrelationMatrix(DataSet dataSet) {
        super(Collections.unmodifiableList(dataSet.getVariables()), dataSet.getCorrelationMatrix(), dataSet.getNumRows());
    }

    public CorrelationMatrix(List<Node> variables, Matrix matrix, int sampleSize) {
        super(variables, MatrixUtils.convertCovToCorr(matrix).copy(), sampleSize);
    }

    public static CorrelationMatrix serializableInstance() {
        return new CorrelationMatrix(new LinkedList<Node>(), new Matrix(0, 0), 1);
    }

    @Override
    public void setMatrix(Matrix matrix) {
        if (!matrix.isSquare()) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        for (int i = 0; i < matrix.getNumRows(); ++i) {
            if (!(FastMath.abs(matrix.get(i, i) - 1.0) > 1.0E-5)) continue;
            throw new IllegalArgumentException("For a correlation matrix, variances (diagonal elements) must be 1.0");
        }
        super.setMatrix(matrix);
    }

    @Override
    public Matrix getSelection(int[] rows, int[] cols) {
        return this.getMatrix().getSelection(rows, cols);
    }

    public CorrelationMatrix getSubCorrMatrix(String[] submatrixVarNames) {
        CovarianceMatrix covarianceMatrix = this.getSubmatrix(submatrixVarNames);
        return new CorrelationMatrix((ICovarianceMatrix)covarianceMatrix);
    }
}

