/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public class CorrelationMatrixOnTheFly
implements ICovarianceMatrix {
    private static final long serialVersionUID = 23L;
    private final ICovarianceMatrix cov;
    private boolean verbose;
    private List<Node> variables;
    private DoubleMatrix2D matrixC;
    private Set<Node> selectedVariables = new HashSet<Node>();

    public CorrelationMatrixOnTheFly(ICovarianceMatrix cov) {
        this.cov = cov;
    }

    public static ICovarianceMatrix serializableInstance() {
        ArrayList<Node> variables = new ArrayList<Node>();
        ContinuousVariable x = new ContinuousVariable("X");
        variables.add(x);
        Matrix matrix = Matrix.identity(1);
        return new CovarianceMatrix(variables, matrix, 100);
    }

    @Override
    public final List<Node> getVariables() {
        return this.cov.getVariables();
    }

    @Override
    public void setVariables(List<Node> variables) {
        if (variables.size() != this.variables.size()) {
            throw new IllegalArgumentException("Wrong # of variables.");
        }
        this.variables = variables;
    }

    @Override
    public final List<String> getVariableNames() {
        return this.cov.getVariableNames();
    }

    @Override
    public final String getVariableName(int index) {
        return this.cov.getVariableName(index);
    }

    @Override
    public final int getDimension() {
        return this.cov.getDimension();
    }

    @Override
    public final int getSampleSize() {
        return this.cov.getSampleSize();
    }

    @Override
    public final void setSampleSize(int sampleSize) {
        this.cov.setSampleSize(sampleSize);
    }

    @Override
    public final String getName() {
        return this.cov.getName() + ".corr";
    }

    @Override
    public final void setName(String name) {
        this.cov.setName(name);
    }

    @Override
    public final Knowledge getKnowledge() {
        return this.cov.getKnowledge();
    }

    @Override
    public final void setKnowledge(Knowledge knowledge) {
        this.cov.setKnowledge(knowledge);
    }

    @Override
    public final ICovarianceMatrix getSubmatrix(int[] indices) {
        LinkedList<Node> submatrixVars = new LinkedList<Node>();
        for (int indice : indices) {
            submatrixVars.add(this.cov.getVariables().get(indice));
        }
        Matrix cov = new Matrix(indices.length, indices.length);
        for (int i = 0; i < indices.length; ++i) {
            for (int j = i; j < indices.length; ++j) {
                double d = this.getValue(indices[i], indices[j]);
                cov.set(i, j, d);
                cov.set(j, i, d);
            }
        }
        return new CovarianceMatrix(submatrixVars, cov, this.getSampleSize());
    }

    @Override
    public final ICovarianceMatrix getSubmatrix(List<String> submatrixVarNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final CorrelationMatrixOnTheFly getSubmatrix(String[] submatrixVarNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final double getValue(int i, int j) {
        double v = this.cov.getValue(i, j);
        return v /= FastMath.sqrt(this.cov.getValue(i, i) * this.cov.getValue(j, j));
    }

    @Override
    public final int getSize() {
        return this.cov.getSize();
    }

    @Override
    public final Matrix getMatrix() {
        Matrix matrix = new Matrix(this.getDimension(), this.getDimension());
        for (int i = 0; i < this.getDimension(); ++i) {
            for (int j = 0; j < this.getDimension(); ++j) {
                matrix.set(i, j, this.getValue(i, j));
            }
        }
        return matrix;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        this.cov.setMatrix(matrix);
    }

    @Override
    public final void select(Node variable) {
        this.cov.select(variable);
    }

    @Override
    public final void clearSelection() {
        this.cov.clearSelection();
    }

    @Override
    public final boolean isSelected(Node variable) {
        return this.cov.isSelected(variable);
    }

    @Override
    public final List<String> getSelectedVariableNames() {
        return this.cov.getSelectedVariableNames();
    }

    @Override
    public final String toString() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        StringBuilder buf = new StringBuilder();
        int numVars = this.getVariableNames().size();
        buf.append(this.getSampleSize()).append("\n");
        for (int i = 0; i < numVars; ++i) {
            String name = this.getVariableNames().get(i);
            buf.append(name).append("\t");
        }
        buf.append("\n");
        for (int j = 0; j < numVars; ++j) {
            for (int i = 0; i <= j; ++i) {
                buf.append(nf.format(this.getValue(i, j))).append("\t");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isDiscrete() {
        return false;
    }

    @Override
    public boolean isMixed() {
        return false;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public Matrix getSelection(int[] rows, int[] cols) {
        Matrix m = new Matrix(rows.length, cols.length);
        if (Arrays.equals(rows, cols)) {
            for (int i = 0; i < rows.length; ++i) {
                for (int j = i; j < cols.length; ++j) {
                    double value = this.getValue(rows[i], cols[j]);
                    m.set(i, j, value);
                    m.set(j, i, value);
                }
            }
        } else {
            for (int i = 0; i < rows.length; ++i) {
                for (int j = 0; j < cols.length; ++j) {
                    double value = this.getValue(rows[i], cols[j]);
                    m.set(i, j, value);
                }
            }
        }
        return m;
    }

    @Override
    public Node getVariable(String name) {
        return this.cov.getVariable(name);
    }

    @Override
    public DataModel copy() {
        return null;
    }

    @Override
    public void setValue(int i, int j, double v) {
        throw new IllegalArgumentException();
    }

    @Override
    public void removeVariables(List<String> remaining) {
        this.cov.removeVariables(remaining);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getVariables() == null) {
            throw new NullPointerException();
        }
        if (this.matrixC != null) {
            this.matrixC = null;
        }
        if (this.selectedVariables == null) {
            this.selectedVariables = new HashSet<Node>();
        }
    }
}

