/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovariancesDoubleForkJoin;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.linear.SingularMatrixException;

public class CovarianceMatrix
implements ICovarianceMatrix {
    private static final long serialVersionUID = 23L;
    private final Matrix _covariancesMatrix;
    private String name;
    private List<Node> variables;
    private int sampleSize;
    private Set<Node> selectedVariables = new HashSet<Node>();
    private Knowledge knowledge = new Knowledge();

    public CovarianceMatrix(DataSet dataSet) {
        this(dataSet, true);
    }

    public CovarianceMatrix(DataSet dataSet, boolean biasCorrected) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Not a continuous data set.");
        }
        CovariancesDoubleForkJoin covariances = new CovariancesDoubleForkJoin(dataSet.getDoubleData().toArray(), biasCorrected);
        this.variables = Collections.unmodifiableList(dataSet.getVariables());
        this.sampleSize = dataSet.getNumRows();
        this._covariancesMatrix = new Matrix(covariances.getMatrix());
    }

    public CovarianceMatrix(List<Node> variables, Matrix matrix, int sampleSize) {
        this(variables, matrix.toArray(), sampleSize);
    }

    public CovarianceMatrix(List<Node> variables, double[][] matrix, int sampleSize) {
        if (variables.size() > matrix.length && variables.size() != matrix[0].length) {
            throw new IllegalArgumentException("# variables not equal to matrix dimension.");
        }
        this._covariancesMatrix = new Matrix(matrix);
        this.variables = variables;
        this.sampleSize = sampleSize;
    }

    public CovarianceMatrix(CovarianceMatrix covMatrix) {
        this._covariancesMatrix = new Matrix(covMatrix.getMatrix());
        this.variables = covMatrix.getVariables();
        this.sampleSize = covMatrix.getSampleSize();
        this.name = covMatrix.getName();
        this.knowledge = covMatrix.getKnowledge();
        this.selectedVariables = covMatrix.getSelectedVariables();
    }

    public CovarianceMatrix(ICovarianceMatrix covMatrix) {
        this(covMatrix.getVariables(), covMatrix.getMatrix(), covMatrix.getSampleSize());
    }

    public static ICovarianceMatrix serializableInstance() {
        ArrayList<Node> variables = new ArrayList<Node>();
        ContinuousVariable x = new ContinuousVariable("X");
        variables.add(x);
        Matrix matrix = Matrix.identity(1);
        return new CovarianceMatrix(variables, matrix, 100);
    }

    @Override
    public final List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public void setVariables(List<Node> variables) {
        if (variables.size() != this.variables.size()) {
            throw new IllegalArgumentException("Wrong # of variables.");
        }
        for (int i = 0; i < variables.size(); ++i) {
            if (!variables.get(i).getName().equals(variables.get(i).getName())) {
                throw new IllegalArgumentException("Variable in index " + (i + 1) + " does not have the same name as the variable being substituted for it.");
            }
            this.variables = variables;
        }
    }

    @Override
    public final List<String> getVariableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            names.add(variable.getName());
        }
        return names;
    }

    @Override
    public final String getVariableName(int index) {
        if (index >= this.getVariables().size()) {
            throw new IllegalArgumentException("Index out of range: " + index);
        }
        Node variable = this.getVariables().get(index);
        return variable.getName();
    }

    @Override
    public final int getDimension() {
        return this.variables.size();
    }

    @Override
    public final int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public final void setSampleSize(int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("Sample size must be > 0.");
        }
        this.sampleSize = sampleSize;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public final Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public final void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge.copy();
    }

    @Override
    public final ICovarianceMatrix getSubmatrix(int[] indices) {
        LinkedList<Node> submatrixVars = new LinkedList<Node>();
        for (int indice : indices) {
            submatrixVars.add(this.variables.get(indice));
        }
        Matrix cov = new Matrix(this._covariancesMatrix.getSelection(indices, indices));
        return new CovarianceMatrix(submatrixVars, cov, this.getSampleSize());
    }

    @Override
    public final ICovarianceMatrix getSubmatrix(List<String> submatrixVarNames) {
        String[] varNames = new String[submatrixVarNames.size()];
        for (int i = 0; i < submatrixVarNames.size(); ++i) {
            varNames[i] = submatrixVarNames.get(i);
        }
        return this.getSubmatrix(varNames);
    }

    @Override
    public final CovarianceMatrix getSubmatrix(String[] submatrixVarNames) {
        LinkedList<Node> submatrixVars = new LinkedList<Node>();
        ArrayList<String> missing = new ArrayList<String>();
        for (String submatrixVarName : submatrixVarNames) {
            if (submatrixVarName.startsWith("E_")) continue;
            Node variable = this.getVariable(submatrixVarName);
            if (variable == null) {
                missing.add(submatrixVarName);
            }
            submatrixVars.add(variable);
        }
        if (!missing.isEmpty()) {
            throw new IllegalArgumentException("The following variables in the submatrix are missing from the data: \n   " + missing + "\nIf there are lagged variables, try using the data box to convert the data to time \nlagged data first.");
        }
        for (int i = 0; i < submatrixVars.size(); ++i) {
            if (submatrixVars.get(i) != null) continue;
            throw new NullPointerException("The variable name at index " + i + " is null.");
        }
        int[] indices = new int[submatrixVars.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.getVariables().indexOf(submatrixVars.get(i));
        }
        Matrix cov = this.getMatrix().getSelection(indices, indices);
        return new CovarianceMatrix(submatrixVars, cov, this.getSampleSize());
    }

    @Override
    public final double getValue(int i, int j) {
        return this._covariancesMatrix.get(i, j);
    }

    @Override
    public final int getSize() {
        return this._covariancesMatrix.getNumColumns();
    }

    @Override
    public final Matrix getMatrix() {
        return this._covariancesMatrix;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        throw new IllegalStateException();
    }

    @Override
    public final void select(Node variable) {
        if (this.variables.contains(variable)) {
            this.getSelectedVariables().add(variable);
        }
    }

    @Override
    public final void clearSelection() {
        this.getSelectedVariables().clear();
    }

    @Override
    public final boolean isSelected(Node variable) {
        if (variable == null) {
            throw new NullPointerException("Null variable. Try again.");
        }
        return this.getSelectedVariables().contains(variable);
    }

    @Override
    public final List<String> getSelectedVariableNames() {
        LinkedList<String> selectedVariableNames = new LinkedList<String>();
        for (Node variable : this.selectedVariables) {
            selectedVariableNames.add(variable.getName());
        }
        return selectedVariableNames;
    }

    @Override
    public final String toString() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        StringBuilder buf = new StringBuilder();
        buf.append(this.sampleSize).append("\n");
        buf.append(String.join((CharSequence)"\t", this.getVariableNames()));
        int numVars = this.getVariableNames().size();
        buf.append("\n");
        for (int j = 0; j < numVars; ++j) {
            for (int i = 0; i <= j; ++i) {
                buf.append(nf.format(this.getValue(i, j)));
                if (i >= j) continue;
                buf.append("\t");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isDiscrete() {
        return false;
    }

    @Override
    public boolean isMixed() {
        return false;
    }

    @Override
    public Matrix getSelection(int[] rows, int[] cols) {
        return this.getMatrix().getSelection(rows, cols);
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!name.equals(variable.getName())) continue;
            return variable;
        }
        return null;
    }

    @Override
    public DataModel copy() {
        return new CovarianceMatrix(this);
    }

    @Override
    public void setValue(int i, int j, double v) {
        this._covariancesMatrix.set(i, j, v);
        this._covariancesMatrix.set(j, i, v);
    }

    @Override
    public void removeVariables(List<String> remaining) {
        throw new IllegalStateException();
    }

    private Set<Node> getSelectedVariables() {
        return this.selectedVariables;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getVariables() == null) {
            throw new NullPointerException();
        }
        if (this.knowledge == null) {
            throw new NullPointerException();
        }
        if (this.sampleSize < -1) {
            throw new IllegalStateException();
        }
        if (this.selectedVariables == null) {
            this.selectedVariables = new HashSet<Node>();
        }
    }

    public boolean isSingular() {
        try {
            this._covariancesMatrix.inverse();
        }
        catch (SingularMatrixException e) {
            return true;
        }
        return false;
    }
}

