/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.RandomGraph;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;
import java.util.List;

public class DataGraphUtils {
    public static Graph randomSingleFactorModel(int numStructuralNodes, int numStructuralEdges, int numMeasurementsPerLatent, int numLatentMeasuredImpureParents, int numMeasuredMeasuredImpureParents, int numMeasuredMeasuredImpureAssociations) {
        Graph dag;
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < numStructuralNodes; ++i) {
            vars.add(new ContinuousVariable("X" + (i + 1)));
        }
        while ((dag = RandomGraph.randomGraphRandomForwardEdges(vars, 0, numStructuralEdges, 30, 15, 15, false, true)).getNumEdges() != numStructuralEdges) {
        }
        EdgeListGraph graph = new EdgeListGraph(dag);
        return DataGraphUtils.randomMim(graph, numMeasurementsPerLatent, numLatentMeasuredImpureParents, numMeasuredMeasuredImpureParents, numMeasuredMeasuredImpureAssociations, true);
    }

    /*
     * WARNING - void declaration
     */
    public static Graph randomMim(Graph graph, int numMeasurementsPerLatent, int numLatentMeasuredImpureParents, int numMeasuredMeasuredImpureParents, int numMeasuredMeasuredImpureAssociations, boolean arrangeGraph) {
        void var9_17;
        Node measure2;
        int k;
        Node measure1;
        int m;
        void var9_15;
        List<Node> measures;
        List<Node> nodes;
        Node latent;
        void var9_13;
        int i;
        int j;
        EdgeListGraph graph1 = new EdgeListGraph(graph);
        List<Node> latents = graph1.getNodes();
        for (Node node : latents) {
            node.setNodeType(NodeType.LATENT);
            if (node.getNodeType() != NodeType.LATENT) {
                throw new IllegalArgumentException("Expected latent.");
            }
            String newName = "L." + node.getName();
            graph1.changeName(node.getName(), newName);
        }
        int measureIndex = 0;
        for (Node latent1 : latents) {
            for (j = 0; j < numMeasurementsPerLatent; ++j) {
                GraphNode measurement = new GraphNode("X" + ++measureIndex);
                graph1.addNode(measurement);
                graph1.addDirectedEdge(latent1, measurement);
            }
        }
        boolean bl = false;
        for (i = 0; i < numLatentMeasuredImpureParents && var9_13 <= 10; ++i) {
            j = RandomUtil.getInstance().nextInt(latents.size());
            latent = latents.get(j);
            nodes = graph1.getNodes();
            measures = graph1.getNodesOutTo(latent, Endpoint.ARROW);
            measures.removeAll(latents);
            nodes.removeAll(latents);
            nodes.removeAll(measures);
            if (nodes.isEmpty()) {
                --i;
                ++var9_13;
                continue;
            }
            int k2 = RandomUtil.getInstance().nextInt(nodes.size());
            Node measure = nodes.get(k2);
            if (graph1.getEdge(latent, measure) != null || graph1.paths().isAncestorOf(measure, latent)) {
                --i;
                ++var9_13;
                continue;
            }
            graph1.addDirectedEdge(latent, measure);
        }
        boolean bl2 = false;
        for (i = 0; i < numMeasuredMeasuredImpureParents && var9_15 <= 10; ++i) {
            j = RandomUtil.getInstance().nextInt(latents.size());
            latent = latents.get(j);
            nodes = graph1.getNodes();
            measures = graph1.getNodesOutTo(latent, Endpoint.ARROW);
            measures.removeAll(latents);
            if (measures.isEmpty()) {
                --i;
                ++var9_15;
                continue;
            }
            m = RandomUtil.getInstance().nextInt(measures.size());
            measure1 = measures.get(m);
            nodes.removeAll(latents);
            nodes.removeAll(measures);
            if (nodes.isEmpty()) {
                --i;
                ++var9_15;
                continue;
            }
            k = RandomUtil.getInstance().nextInt(nodes.size());
            measure2 = nodes.get(k);
            if (graph1.getEdge(measure1, measure2) != null || graph1.paths().isAncestorOf(measure2, measure1)) {
                --i;
                ++var9_15;
                continue;
            }
            graph1.addDirectedEdge(measure1, measure2);
        }
        boolean bl3 = false;
        for (i = 0; i < numMeasuredMeasuredImpureAssociations && var9_17 <= 10; ++i) {
            j = RandomUtil.getInstance().nextInt(latents.size());
            latent = latents.get(j);
            nodes = graph1.getNodes();
            measures = graph1.getNodesOutTo(latent, Endpoint.ARROW);
            measures.removeAll(latents);
            if (measures.isEmpty()) {
                --i;
                ++var9_17;
                continue;
            }
            m = RandomUtil.getInstance().nextInt(measures.size());
            measure1 = measures.get(m);
            nodes.removeAll(latents);
            nodes.removeAll(measures);
            if (nodes.isEmpty()) {
                --i;
                ++var9_17;
                continue;
            }
            k = RandomUtil.getInstance().nextInt(nodes.size());
            measure2 = nodes.get(k);
            if (graph1.getEdge(measure1, measure2) != null) {
                --i;
                ++var9_17;
                continue;
            }
            graph1.addBidirectedEdge(measure1, measure2);
        }
        if (arrangeGraph) {
            LayoutUtil.defaultLayout(graph1);
            LayoutUtil.fruchtermanReingoldLayout(graph1);
        }
        return graph1;
    }

    public static Graph randomBifactorModel(int numStructuralNodes, int numStructuralEdges, int numMeasurementsPerLatent, int numLatentMeasuredImpureParents, int numMeasuredMeasuredImpureParents, int numMeasuredMeasuredImpureAssociations) {
        Graph mim = DataGraphUtils.randomSingleFactorModel(numStructuralNodes, numStructuralEdges, numMeasurementsPerLatent, numLatentMeasuredImpureParents, numMeasuredMeasuredImpureParents, numMeasuredMeasuredImpureAssociations);
        ArrayList<Node> latents = new ArrayList<Node>();
        ArrayList<GraphNode> latents2 = new ArrayList<GraphNode>();
        for (Node node : mim.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            latents.add(node);
            GraphNode node2 = new GraphNode(node.getName() + "B");
            node2.setNodeType(NodeType.LATENT);
            latents2.add(node2);
            mim.addNode(node2);
        }
        for (int i = 0; i < latents.size(); ++i) {
            Node latent = (Node)latents.get(i);
            for (Node child : mim.getChildren(latent)) {
                if (child.getNodeType() == NodeType.MEASURED) {
                    mim.addDirectedEdge((Node)latents2.get(i), child);
                    continue;
                }
                int j = latents.indexOf(child);
                mim.addDirectedEdge((Node)latents2.get(i), (Node)latents2.get(j));
            }
        }
        LayoutUtil.fruchtermanReingoldLayout(mim);
        return mim;
    }
}

