/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.AbstractVariable;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteVariableType;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.NodeVariableType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class DiscreteVariable
extends AbstractVariable
implements Node {
    public static final int MISSING_VALUE = -99;
    private static final long serialVersionUID = 23L;
    private static final String MISSING_VALUE_STRING = "*";
    private static List<LinkedList<String>> STORED_CATEGORY_LISTS;
    private transient List<String> categories;
    private List<String> categoriesCopy = new ArrayList<String>();
    private DiscreteVariableType discreteVariableType = DiscreteVariableType.NOMINAL;
    private boolean categoryNamesDisplayed = true;
    private NodeType nodeType = NodeType.MEASURED;
    private NodeVariableType nodeVariableType = NodeVariableType.DOMAIN;
    private boolean accommodateNewCategories = true;
    private int centerX = -1;
    private int centerY = -1;
    private transient PropertyChangeSupport pcs;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public DiscreteVariable(String name) {
        super(name);
    }

    public DiscreteVariable(String name, int numCategories) {
        super(name);
        this.setCategories(numCategories);
        this.setCategoryNamesDisplayed(false);
    }

    public DiscreteVariable(String name, List<String> categories) {
        super(name);
        this.setCategories(categories.toArray(new String[0]));
        this.setCategoryNamesDisplayed(true);
    }

    public DiscreteVariable(DiscreteVariable variable) {
        super(variable.getName());
        this.categoriesCopy = DiscreteVariable.getStoredCategoryList(variable.getCategories());
        this.accommodateNewCategories = variable.accommodateNewCategories;
        this.attributes = new HashMap<String, Object>(variable.attributes);
        this.categories = new ArrayList<String>(variable.categories);
        this.discreteVariableType = variable.discreteVariableType;
        this.centerX = variable.centerX;
        this.centerY = variable.centerY;
        this.nodeType = variable.nodeType;
        this.nodeVariableType = variable.nodeVariableType;
        this.setCategoryNamesDisplayed(true);
    }

    public static DiscreteVariable serializableInstance() {
        return new DiscreteVariable("X");
    }

    private static List<String> getStoredCategoryList(List<String> categoryList) {
        if (categoryList == null) {
            throw new NullPointerException();
        }
        HashSet<String> categorySet = new HashSet<String>(categoryList);
        if (STORED_CATEGORY_LISTS == null) {
            STORED_CATEGORY_LISTS = new ArrayList<LinkedList<String>>();
        }
        for (LinkedList<String> list : STORED_CATEGORY_LISTS) {
            if (!categorySet.equals(new HashSet<String>(list))) continue;
            return list;
        }
        LinkedList<String> newList = new LinkedList<String>(categoryList);
        STORED_CATEGORY_LISTS.add(newList);
        return newList;
    }

    public int getIndex(String category) {
        return this.getCategories().indexOf(category);
    }

    public int getNumCategories() {
        return this.getCategories().size();
    }

    @Override
    public Object getMissingValueMarker() {
        return -99;
    }

    public String getCategory(int category) {
        if (category == -99) {
            return MISSING_VALUE_STRING;
        }
        return this.getCategories().get(category);
    }

    public List<String> getCategories() {
        if (this.categories == null) {
            this.categories = Collections.unmodifiableList(DiscreteVariable.getStoredCategoryList(this.categoriesCopy));
        }
        return this.categories;
    }

    private void setCategories(String[] categories) {
        for (String category : categories) {
            if (category != null) continue;
            throw new NullPointerException();
        }
        List<String> categoryList = Arrays.asList(categories);
        if (new HashSet<String>(categoryList).size() != categoryList.size()) {
            throw new IllegalArgumentException("Duplicate category.");
        }
        this.categoriesCopy = Collections.unmodifiableList(DiscreteVariable.getStoredCategoryList(categoryList));
    }

    private void setCategories(int numCategories) {
        String[] categories = new String[numCategories];
        for (int i = 0; i < numCategories; ++i) {
            categories[i] = DataUtils.defaultCategory(i);
        }
        this.setCategories(categories);
    }

    public boolean checkValue(int category) {
        boolean inRange = category >= 0 && category < this.getNumCategories();
        boolean isMissing = category == -99;
        return inRange || isMissing;
    }

    @Override
    public boolean isMissingValue(Object value) {
        if (value instanceof Integer) {
            Integer ivalue = (Integer)value;
            return ivalue == -99;
        }
        if (value instanceof String) {
            return MISSING_VALUE_STRING.equals(value);
        }
        return false;
    }

    public boolean isCategoryNamesDisplayed() {
        return this.categoryNamesDisplayed;
    }

    public void setCategoryNamesDisplayed(boolean categoryNamesDisplayed) {
        this.categoryNamesDisplayed = categoryNamesDisplayed;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DiscreteVariable)) {
            return false;
        }
        if (!this.getName().equals(((Node)o).getName())) {
            return false;
        }
        DiscreteVariable variable = (DiscreteVariable)o;
        if (this.getNumCategories() != variable.getNumCategories()) {
            return false;
        }
        for (int i = 0; i < this.getNumCategories(); ++i) {
            if (this.getCategory(i).equals(variable.getCategory(i))) continue;
            return false;
        }
        return this.getNodeType() == variable.getNodeType();
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public boolean isAccommodateNewCategories() {
        return this.accommodateNewCategories;
    }

    @Override
    public int getCenterX() {
        return this.centerX;
    }

    @Override
    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    @Override
    public int getCenterY() {
        return this.centerY;
    }

    @Override
    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    @Override
    public void setCenter(int centerX, int centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Node like(String name) {
        DiscreteVariable variable = new DiscreteVariable(name);
        variable.setNodeType(this.getNodeType());
        return variable;
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.categoriesCopy == null) {
            throw new NullPointerException();
        }
        if (this.discreteVariableType == null) {
            throw new NullPointerException();
        }
        if (this.nodeType == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public NodeVariableType getNodeVariableType() {
        return this.nodeVariableType;
    }

    @Override
    public void setNodeVariableType(NodeVariableType nodeVariableType) {
        this.nodeVariableType = nodeVariableType;
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }
}

