/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.util.FastMath;

public class GeneralAndersonDarlingTest {
    private final List<Double> data;
    private final RealDistribution dist;
    private double aSquared;
    private double aSquaredStar;
    private double p;

    public GeneralAndersonDarlingTest(List<Double> data, RealDistribution dist) {
        if (dist == null) {
            throw new NullPointerException();
        }
        this.dist = dist;
        Collections.sort(data);
        this.data = data;
        this.runTest();
    }

    public double getASquared() {
        return this.aSquared;
    }

    public double getASquaredStar() {
        return this.aSquaredStar;
    }

    public double getP() {
        return this.p;
    }

    private void runTest() {
        int n = this.data.size();
        double h = 0.0;
        int numSummed = 0;
        for (int i = 1; i <= n; ++i) {
            double x1 = this.data.get(i - 1);
            double a1 = FastMath.log(this.dist.cumulativeProbability(x1));
            double x2 = this.data.get(n + 1 - i - 1);
            double a2 = FastMath.log(1.0 - this.dist.cumulativeProbability(x2));
            double k = (double)(2 * i - 1) * (a1 + a2);
            if (Double.isNaN(a1) || Double.isNaN(a2) || Double.isInfinite(a1) || Double.isInfinite(a2)) continue;
            h += k;
            ++numSummed;
        }
        double a = (double)(-n) - 1.0 / (double)numSummed * h;
        double aa = (1.0 + 0.75 / (double)numSummed + 2.25 / FastMath.pow((double)numSummed, 2)) * a;
        double p = aa < 0.2 ? 1.0 - FastMath.exp(-13.436 + 101.14 * aa - 223.73 * aa * aa) : (aa < 0.34 ? 1.0 - FastMath.exp(-8.318 + 42.796 * aa - 59.938 * aa * aa) : (aa < 0.6 ? FastMath.exp(0.9177 - 4.279 * aa - 1.38 * aa * aa) : FastMath.exp(1.2937 - 5.709 * aa + 0.0186 * aa * aa)));
        this.aSquared = a;
        this.aSquaredStar = aa;
        this.p = p;
    }
}

