/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.StatUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Histogram {
    private final DataSet dataSet;
    private final boolean removeZeroPointsPerPlot;
    private Node target;
    private int numBins = 10;
    private Map<Node, double[]> continuousIntervals;
    private Map<Node, Integer> discreteValues;

    public Histogram(DataSet dataSet, String target, boolean removeZeroPointsPerPlot) {
        if (dataSet.getVariables().size() < 1) {
            throw new IllegalArgumentException("Can't do histograms for an empty data sets.");
        }
        this.dataSet = dataSet;
        this.removeZeroPointsPerPlot = removeZeroPointsPerPlot;
        this.setTarget(target);
    }

    public void addConditioningVariable(String variable, double low, double high) {
        if (!(low < high)) {
            throw new IllegalArgumentException("Low must be less than high: " + low + " >= " + high);
        }
        Node node = this.dataSet.getVariable(variable);
        if (!(node instanceof ContinuousVariable)) {
            throw new IllegalArgumentException("Variable must be continuous.");
        }
        if (this.continuousIntervals.containsKey(node)) {
            throw new IllegalArgumentException("Please remove conditioning variable first.");
        }
        this.continuousIntervals.put(node, new double[]{low, high});
    }

    public void addConditioningVariable(String variable, int value) {
        Node node = this.dataSet.getVariable(variable);
        if (!(node instanceof DiscreteVariable)) {
            throw new IllegalArgumentException("Variable must be discrete.");
        }
        this.discreteValues.put(node, value);
    }

    public void removeConditioningVariable(String variable) {
        Node node = this.dataSet.getVariable(variable);
        if (!this.continuousIntervals.containsKey(node) && !this.discreteValues.containsKey(node)) {
            throw new IllegalArgumentException("Not a conditioning node: " + variable);
        }
        this.continuousIntervals.remove(node);
        this.discreteValues.remove(node);
    }

    public void setNumBins(int numBins) {
        if (this.target instanceof DiscreteVariable) {
            throw new IllegalArgumentException("Can't set number of bins for a discrete target.");
        }
        this.numBins = numBins;
    }

    public int[] getFrequencies() {
        if (this.target instanceof ContinuousVariable) {
            List<Double> _data = this.getConditionedDataContinuous();
            _data = this.removeZeroPointsPerPlot(_data);
            double[] breakpoints = this.getBreakpoints(_data, this.numBins);
            int[] counts = new int[this.numBins];
            for (Double d : _data) {
                boolean sorted = false;
                for (int h = 0; h < breakpoints.length; ++h) {
                    if (!(breakpoints[h] > d)) continue;
                    int n = h;
                    counts[n] = counts[n] + 1;
                    sorted = true;
                    break;
                }
                if (sorted) continue;
                int n = breakpoints.length;
                counts[n] = counts[n] + 1;
            }
            return counts;
        }
        if (this.target instanceof DiscreteVariable) {
            DiscreteVariable _var = (DiscreteVariable)this.target;
            List<Integer> _data = this.getConditionedDataDiscrete();
            int[] counts = new int[_var.getNumCategories()];
            for (Integer d : _data) {
                int n = d;
                counts[n] = counts[n] + 1;
            }
            return counts;
        }
        throw new IllegalArgumentException("Unrecognized variable type.");
    }

    private List<Double> removeZeroPointsPerPlot(List<Double> data) {
        ArrayList<Double> _data = new ArrayList<Double>();
        for (double d : data) {
            if (this.removeZeroPointsPerPlot && d == 0.0) continue;
            _data.add(d);
        }
        return _data;
    }

    public double getMax() {
        List<Double> conditionedDataContinuous = this.getUnconditionedDataContinuous();
        double[] d = this.asDoubleArray(conditionedDataContinuous);
        return StatUtils.max(d);
    }

    public double getMin() {
        List<Double> conditionedDataContinuous = this.getUnconditionedDataContinuous();
        double[] d = this.asDoubleArray(conditionedDataContinuous);
        return StatUtils.min(d);
    }

    public int getN() {
        List<Double> conditionedDataContinuous = this.getConditionedDataContinuous();
        return conditionedDataContinuous.size();
    }

    public double[] getContinuousData(String variable) {
        int index = this.dataSet.getColumn(this.dataSet.getVariable(variable));
        ArrayList<Double> _data = new ArrayList<Double>();
        for (int i = 0; i < this.dataSet.getNumRows(); ++i) {
            _data.add(this.dataSet.getDouble(i, index));
        }
        return this.asDoubleArray(_data);
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public String getTarget() {
        return this.target.getName();
    }

    private void setTarget(String target) {
        Node _target = target == null ? this.dataSet.getVariable(0) : this.dataSet.getVariable(target);
        this.target = _target;
        this.continuousIntervals = new HashMap<Node, double[]>();
        this.discreteValues = new HashMap<Node, Integer>();
    }

    public Node getTargetNode() {
        return this.target;
    }

    private double[] getBreakpoints(List<Double> data, int numBins) {
        double[] _data = this.asDoubleArray(data);
        if (data.isEmpty()) {
            throw new IllegalArgumentException("No data.");
        }
        double max = StatUtils.max(_data);
        double min = StatUtils.min(_data);
        double interval = (max - min) / (double)numBins;
        double[] breakpoints = new double[numBins - 1];
        for (int g = 0; g < numBins - 1; ++g) {
            breakpoints[g] = min + (double)(g + 1) * interval;
        }
        return breakpoints;
    }

    private double[] asDoubleArray(List<Double> data) {
        double[] _data = new double[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            _data[i] = data.get(i);
        }
        return _data;
    }

    private List<Double> getUnconditionedDataContinuous() {
        int index = this.dataSet.getColumn(this.target);
        ArrayList<Double> _data = new ArrayList<Double>();
        for (int i = 0; i < this.dataSet.getNumRows(); ++i) {
            _data.add(this.dataSet.getDouble(i, index));
        }
        return _data;
    }

    private List<Double> getConditionedDataContinuous() {
        List<Integer> rows = this.getConditionedRows();
        int index = this.dataSet.getColumn(this.target);
        ArrayList<Double> _data = new ArrayList<Double>();
        for (Integer row : rows) {
            _data.add(this.dataSet.getDouble(row, index));
        }
        return _data;
    }

    private List<Integer> getConditionedDataDiscrete() {
        List<Integer> rows = this.getConditionedRows();
        int index = this.dataSet.getColumn(this.target);
        ArrayList<Integer> _data = new ArrayList<Integer>();
        for (Integer row : rows) {
            _data.add(this.dataSet.getInt(row, index));
        }
        return _data;
    }

    private List<Integer> getConditionedRows() {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        block0: for (int i = 0; i < this.dataSet.getNumRows(); ++i) {
            int index;
            for (Node node : this.continuousIntervals.keySet()) {
                double[] range = this.continuousIntervals.get(node);
                index = this.dataSet.getColumn(node);
                double value = this.dataSet.getDouble(i, index);
                if (value >= range[0] && value <= range[1]) continue;
                continue block0;
            }
            for (Node node : this.discreteValues.keySet()) {
                int _value;
                int value = this.discreteValues.get(node);
                if (value == (_value = this.dataSet.getInt(i, index = this.dataSet.getColumn(node)))) continue;
                continue block0;
            }
            rows.add(i);
        }
        return rows;
    }
}

