/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.test.MsepTest;
import edu.cmu.tetrad.util.PermutationGenerator;
import edu.cmu.tetrad.util.SublistGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class IndependenceFacts
implements DataModel {
    private static final long serialVersionUID = 23L;
    private List<Node> nodes = new ArrayList<Node>();
    private Set<IndependenceFact> unsortedFacts = new LinkedHashSet<IndependenceFact>();
    private String name = "";
    private Knowledge knowledge = new Knowledge();

    public IndependenceFacts() {
    }

    public IndependenceFacts(Graph graph) {
        int[] choice;
        MsepTest msep = new MsepTest(graph);
        HashSet<IndependenceFact> facts = new HashSet<IndependenceFact>();
        this.nodes = graph.getNodes();
        SublistGenerator gen = new SublistGenerator(this.nodes.size(), this.nodes.size());
        while ((choice = gen.next()) != null) {
            int[] perm;
            if (choice.length < 2) continue;
            PermutationGenerator permGen = new PermutationGenerator(choice.length);
            while ((perm = permGen.next()) != null) {
                Node x = this.nodes.get(choice[perm[0]]);
                Node y = this.nodes.get(choice[perm[1]]);
                HashSet<Node> Z = new HashSet<Node>();
                for (int i = 2; i < perm.length; ++i) {
                    Z.add(this.nodes.get(choice[perm[i]]));
                }
                if (!msep.checkIndependence(x, y, Z).isIndependent()) continue;
                facts.add(new IndependenceFact(x, y, Z));
            }
            this.unsortedFacts = facts;
        }
    }

    public IndependenceFacts(IndependenceFacts facts) {
        this();
        if (facts == null) {
            throw new NullPointerException("Facts is null.");
        }
        if (facts.nodes == null) {
            throw new NullPointerException("Facts nodes is null.");
        }
        this.unsortedFacts = new HashSet<IndependenceFact>(facts.unsortedFacts);
        this.name = facts.name;
        this.knowledge = facts.knowledge.copy();
        this.nodes = new ArrayList<Node>(facts.nodes);
    }

    public static IndependenceFacts serializableInstance() {
        return new IndependenceFacts();
    }

    public void add(IndependenceFact fact) {
        this.unsortedFacts.add(fact);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        for (IndependenceFact fact : this.unsortedFacts) {
            builder.append(fact).append("\n");
        }
        return builder.toString();
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isDiscrete() {
        return false;
    }

    @Override
    public boolean isMixed() {
        return false;
    }

    @Override
    public Node getVariable(String name) {
        return null;
    }

    @Override
    public DataModel copy() {
        return null;
    }

    public void remove(IndependenceFact fact) {
        this.unsortedFacts.remove(fact);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean isIndependent(Node x, Node y, Node ... z) {
        for (IndependenceFact fact : this.unsortedFacts) {
            if ((!fact.getX().equals(x) || !fact.getY().equals(y)) && (!fact.getX().equals(y) || !fact.getY().equals(x))) continue;
            HashSet cond = new HashSet();
            Collections.addAll(cond, z);
            if (!cond.equals(new HashSet<Node>(fact.getZ()))) continue;
            return true;
        }
        return false;
    }

    public boolean isIndependent(Node x, Node y, Set<Node> z) {
        boolean found = false;
        for (IndependenceFact fact : this.unsortedFacts) {
            if ((!fact.getX().equals(x) || !fact.getY().equals(y)) && (!fact.getX().equals(y) || !fact.getY().equals(x)) || !new HashSet<Node>(fact.getZ()).equals(new HashSet<Node>(z))) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    @Override
    public List<Node> getVariables() {
        if (this.nodes != null && !this.nodes.isEmpty()) {
            return this.nodes;
        }
        HashSet<Node> variables = new HashSet<Node>();
        for (IndependenceFact fact : this.unsortedFacts) {
            variables.add(fact.getX());
            variables.add(fact.getY());
            variables.addAll(fact.getZ());
        }
        if (this.nodes != null && !this.nodes.isEmpty()) {
            if (new HashSet(variables).equals(new HashSet<Node>(this.nodes))) {
                return this.nodes;
            }
            throw new IllegalArgumentException("The supplied order is not precisely for the variables in the facts.");
        }
        return new ArrayList<Node>(variables);
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : variables) {
            names.add(node.getName());
        }
        return names;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = Collections.unmodifiableList(nodes);
    }

    public int size() {
        return this.unsortedFacts.size();
    }

    public List<IndependenceFact> getFacts() {
        return new ArrayList<IndependenceFact>(this.unsortedFacts);
    }
}

