/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class KnowledgeGroup
implements TetradSerializable {
    public static final int REQUIRED = 1;
    public static final int FORBIDDEN = 2;
    private static final long serialVersionUID = 23L;
    private final Set<String> fromGroup;
    private final Set<String> toGroup;
    private final int type;

    public KnowledgeGroup(int type, Set<String> from, Set<String> to) {
        if (type != 1 && type != 2) {
            throw new NullPointerException("The given type needs to be either REQUIRED or FORBIDDEN");
        }
        if (from == null) {
            throw new NullPointerException("The from set must not be null");
        }
        if (to == null) {
            throw new NullPointerException("The to set must not be null");
        }
        if (KnowledgeGroup.intersect(from, to)) {
            throw new IllegalArgumentException("The from and to sets must not intersect");
        }
        this.fromGroup = new HashSet<String>(from);
        this.toGroup = new HashSet<String>(to);
        this.type = type;
    }

    public KnowledgeGroup(int type) {
        if (type != 1 && type != 2) {
            throw new NullPointerException("The given type needs to be either REQUIRED or FORBIDDEN");
        }
        this.type = type;
        this.fromGroup = Collections.emptySet();
        this.toGroup = Collections.emptySet();
    }

    public static KnowledgeGroup serializableInstance() {
        return new KnowledgeGroup(1, new HashSet<String>(0), new HashSet<String>(0));
    }

    private static boolean intersect(Set<String> set1, Set<String> set2) {
        for (String var : set1) {
            if (!set2.contains(var)) continue;
            return true;
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.fromGroup.isEmpty() || this.toGroup.isEmpty();
    }

    public Set<String> getFromVariables() {
        return Collections.unmodifiableSet(this.fromGroup);
    }

    public Set<String> getToVariables() {
        return Collections.unmodifiableSet(this.toGroup);
    }

    public List<KnowledgeEdge> getEdges() {
        ArrayList<KnowledgeEdge> edges = new ArrayList<KnowledgeEdge>(this.fromGroup.size() + this.toGroup.size());
        for (String from : this.fromGroup) {
            for (String to : this.toGroup) {
                edges.add(new KnowledgeEdge(from, to));
            }
        }
        return edges;
    }

    public boolean containsEdge(KnowledgeEdge edge) {
        return this.fromGroup.contains(edge.getFrom()) && this.toGroup.contains(edge.getTo());
    }

    public int hashCode() {
        int hash = 37;
        hash += 17 * this.fromGroup.hashCode() + 37;
        hash += 17 * this.toGroup.hashCode() + 37;
        return hash += 17 * Integer.valueOf(this.type).hashCode() + 37;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KnowledgeGroup)) {
            return false;
        }
        KnowledgeGroup thatGroup = (KnowledgeGroup)o;
        return this.type == thatGroup.type && this.fromGroup.equals(thatGroup.fromGroup) && this.toGroup.equals(thatGroup.toGroup);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.type != 1 && this.type != 2) {
            throw new IllegalStateException("Type must be REQUIRED or FORBIDDEN");
        }
        if (this.fromGroup == null) {
            throw new NullPointerException();
        }
        if (this.toGroup == null) {
            throw new NullPointerException();
        }
    }
}

