/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

final class Lineizer {
    private final BufferedReader reader;
    private final String commentMarker;
    private String tempLine;
    private int lineNumber;

    public Lineizer(Reader reader, String commentMarker) {
        if (reader == null) {
            throw new NullPointerException();
        }
        if (commentMarker == null) {
            throw new NullPointerException();
        }
        this.reader = new BufferedReader(reader);
        this.commentMarker = commentMarker;
    }

    public boolean hasMoreLines() {
        if (this.tempLine == null) {
            try {
                this.tempLine = this.readLine();
                return this.tempLine != null;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public String nextLine() {
        ++this.lineNumber;
        if (this.tempLine == null) {
            try {
                return this.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String line = this.tempLine;
        this.tempLine = null;
        return line;
    }

    private String readLine() throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null) {
            if ("".equals(line) || line.startsWith(this.commentMarker)) continue;
            return line;
        }
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

