/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataFilter;
import edu.cmu.tetrad.data.DataSet;

public final class MeanInterpolator
implements DataFilter {
    @Override
    public DataSet filter(DataSet dataSet) {
        DataSet newDataSet = dataSet.copy();
        for (int j = 0; j < newDataSet.getNumColumns(); ++j) {
            if (!(newDataSet.getVariable(j) instanceof ContinuousVariable)) continue;
            double sum = 0.0;
            int count = 0;
            for (int i = 0; i < newDataSet.getNumRows(); ++i) {
                if (Double.isNaN(newDataSet.getDouble(i, j))) continue;
                sum += newDataSet.getDouble(i, j);
                ++count;
            }
            double mean = sum / (double)count;
            for (int i = 0; i < newDataSet.getNumRows(); ++i) {
                if (!Double.isNaN(newDataSet.getDouble(i, j))) continue;
                newDataSet.setDouble(i, j, mean);
            }
        }
        return newDataSet;
    }
}

