/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;

public final class RandomSampler {
    public static DataSet sample(DataSet dataSet, int newSampleSize) {
        if (newSampleSize < 1) {
            throw new IllegalArgumentException("Sample size must be > 0.");
        }
        if (dataSet.getNumRows() < 1) {
            throw new IllegalArgumentException("Dataset must contain samples.");
        }
        if (dataSet.getNumRows() < newSampleSize) {
            throw new IllegalArgumentException("Not enough cases in data to generate " + newSampleSize + " samples without replacement.");
        }
        ArrayList<Integer> indices = new ArrayList<Integer>(dataSet.getNumRows());
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            indices.add(i);
        }
        RandomUtil.shuffle(indices);
        int ncols = dataSet.getNumColumns();
        BoxDataSet newDataSet = new BoxDataSet(new VerticalDoubleDataBox(newSampleSize, dataSet.getVariables().size()), dataSet.getVariables());
        for (int i = 0; i < newSampleSize; ++i) {
            int oldCase = (Integer)indices.get(i);
            for (int j = 0; j < ncols; ++j) {
                newDataSet.setObject(i, j, dataSet.getObject(oldCase, j));
            }
        }
        return newDataSet;
    }
}

