/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.CovarianceMatrixOnTheFly;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DelimiterType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeGroup;
import edu.cmu.tetrad.data.Lineizer;
import edu.cmu.tetrad.data.RegexTokenizer;
import edu.cmu.tetrad.util.DataConvertUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.TetradLogger;
import edu.pitt.dbmi.data.reader.Data;
import edu.pitt.dbmi.data.reader.DataColumn;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.tabular.TabularColumnFileReader;
import edu.pitt.dbmi.data.reader.tabular.TabularDataFileReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SimpleDataLoader {
    @NotNull
    public static DataSet loadContinuousData(File file, String commentMarker, char quoteCharacter, String missingValueMarker, boolean hasHeader, Delimiter delimiter, boolean excludeFirstColumn) throws IOException {
        int[] nArray;
        TabularColumnFileReader columnReader = new TabularColumnFileReader(file.toPath(), delimiter);
        if (excludeFirstColumn) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            nArray = new int[]{};
        }
        DataColumn[] dataColumns = columnReader.readInDataColumns(nArray, false);
        columnReader.setCommentMarker(commentMarker);
        TabularDataFileReader dataReader = new TabularDataFileReader(file.toPath(), delimiter);
        dataReader.setCommentMarker(commentMarker);
        dataReader.setMissingDataMarker(missingValueMarker);
        dataReader.setQuoteCharacter(quoteCharacter);
        Data data = dataReader.read(dataColumns, hasHeader);
        DataModel dataModel = DataConvertUtils.toDataModel(data);
        dataModel.setName(file.getName());
        return (DataSet)dataModel;
    }

    @NotNull
    public static DataSet loadDiscreteData(File file, String commentMarker, char quoteCharacter, String missingValueMarker, boolean hasHeader, Delimiter delimiter, boolean excludeFirstColumn) throws IOException {
        int[] nArray;
        TabularColumnFileReader columnReader = new TabularColumnFileReader(file.toPath(), delimiter);
        if (excludeFirstColumn) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            nArray = new int[]{};
        }
        DataColumn[] dataColumns = columnReader.readInDataColumns(nArray, true);
        columnReader.setCommentMarker(commentMarker);
        TabularDataFileReader dataReader = new TabularDataFileReader(file.toPath(), delimiter);
        dataReader.setCommentMarker(commentMarker);
        dataReader.setMissingDataMarker(missingValueMarker);
        dataReader.setQuoteCharacter(quoteCharacter);
        Data data = dataReader.read(dataColumns, hasHeader);
        DataModel dataModel = DataConvertUtils.toDataModel(data);
        dataModel.setName(file.getName());
        return (DataSet)dataModel;
    }

    @NotNull
    public static DataSet loadMixedData(File file, String commentMarker, char quoteCharacter, String missingValueMarker, boolean hasHeader, int maxNumCategories, Delimiter delimiter, boolean excludeFirstColumn) throws IOException {
        int[] nArray;
        TabularColumnFileReader columnReader = new TabularColumnFileReader(file.toPath(), delimiter);
        if (excludeFirstColumn) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            nArray = new int[]{};
        }
        DataColumn[] dataColumns = columnReader.readInDataColumns(nArray, false);
        columnReader.setCommentMarker(commentMarker);
        TabularDataFileReader dataReader = new TabularDataFileReader(file.toPath(), delimiter);
        dataReader.setCommentMarker(commentMarker);
        dataReader.setMissingDataMarker(missingValueMarker);
        dataReader.setQuoteCharacter(quoteCharacter);
        dataReader.determineDiscreteDataColumns(dataColumns, maxNumCategories, hasHeader);
        Data data = dataReader.read(dataColumns, hasHeader);
        if (data != null) {
            DataModel dataModel = DataConvertUtils.toDataModel(data);
            dataModel.setName(file.getName());
            return (DataSet)dataModel;
        }
        return null;
    }

    public static ICovarianceMatrix loadCovarianceMatrix(char[] chars, String commentMarker, DelimiterType delimiterType, char quoteChar, String missingValueMarker) {
        CharArrayReader reader = new CharArrayReader(chars);
        reader.close();
        CharArrayReader reader2 = new CharArrayReader(chars);
        ICovarianceMatrix covarianceMatrix = SimpleDataLoader.doCovariancePass(reader2, commentMarker, delimiterType, quoteChar, missingValueMarker);
        TetradLogger.getInstance().log("info", "\nData set loaded!");
        return covarianceMatrix;
    }

    public static ICovarianceMatrix loadCovarianceMatrix(File file, String commentMarker, DelimiterType delimiter, char quoteCharacter, String missingValueMarker) throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            ICovarianceMatrix covarianceMatrix = SimpleDataLoader.doCovariancePass(reader, commentMarker, delimiter, quoteCharacter, missingValueMarker);
            TetradLogger.getInstance().log("info", "\nCovariance matrix loaded!");
            return covarianceMatrix;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            if (reader != null) {
                reader.close();
            }
            throw new RuntimeException("Parsing failed.", e);
        }
    }

    private static ICovarianceMatrix doCovariancePass(Reader reader, String commentMarker, DelimiterType delimiterType, char quoteChar, String missingValueMarker) {
        int n;
        TetradLogger.getInstance().log("info", "\nDATA LOADING PARAMETERS:");
        TetradLogger.getInstance().log("info", "File type = COVARIANCE");
        TetradLogger.getInstance().log("info", "Comment marker = " + commentMarker);
        TetradLogger.getInstance().log("info", "Delimiter type = " + delimiterType);
        TetradLogger.getInstance().log("info", "Quote char = " + quoteChar);
        TetradLogger.getInstance().log("info", "Missing value marker = " + missingValueMarker);
        TetradLogger.getInstance().log("info", "--------------------");
        Lineizer lineizer = new Lineizer(reader, commentMarker);
        String line = lineizer.nextLine();
        if ("/Covariance".equalsIgnoreCase(line.trim())) {
            line = lineizer.nextLine();
        }
        RegexTokenizer st = new RegexTokenizer(line, delimiterType.getPattern(), quoteChar);
        String token = st.nextToken();
        try {
            n = Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected a sample size here, got \"" + token + "\".");
        }
        if (st.hasMoreTokens() && !"".equals(st.nextToken())) {
            throw new IllegalArgumentException("Line from file has more tokens than expected: \"" + st.nextToken() + "\"");
        }
        line = lineizer.nextLine();
        if (line.subSequence(line.length() - 1, line.length()).equals("\t")) {
            line = line.substring(0, line.length() - 1);
        }
        st = new RegexTokenizer(line, delimiterType.getPattern(), quoteChar);
        ArrayList<String> vars = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String _token = st.nextToken();
            if ("".equals(_token)) {
                TetradLogger.getInstance().log("emptyToken", "Parsed an empty token for a variable name--ignoring.");
                continue;
            }
            vars.add(_token);
        }
        String[] varNames = vars.toArray(new String[0]);
        TetradLogger.getInstance().log("info", "Variables:");
        for (String varName : varNames) {
            TetradLogger.getInstance().log("info", varName + " --> Continuous");
        }
        Matrix c = new Matrix(vars.size(), vars.size());
        for (int i = 0; i < vars.size(); ++i) {
            st = new RegexTokenizer(lineizer.nextLine(), delimiterType.getPattern(), quoteChar);
            for (int j = 0; j <= i; ++j) {
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException("Expecting " + (i + 1) + " numbers on line " + (i + 1) + " of the covariance matrix input.");
                }
                String literal = st.nextToken();
                if ("".equals(literal)) {
                    TetradLogger.getInstance().log("emptyToken", "Parsed an empty token for a covariance value--ignoring.");
                    continue;
                }
                if ("*".equals(literal)) {
                    c.set(i, j, Double.NaN);
                    c.set(j, i, Double.NaN);
                    continue;
                }
                double r = Double.parseDouble(literal);
                c.set(i, j, r);
                c.set(j, i, r);
            }
        }
        Knowledge knowledge = SimpleDataLoader.loadKnowledge(lineizer, delimiterType.getPattern());
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(DataUtils.createContinuousVariables(varNames), c, n);
        covarianceMatrix.setKnowledge(knowledge);
        TetradLogger.getInstance().log("info", "\nData set loaded!");
        return covarianceMatrix;
    }

    public static DataSet getDiscreteDataSet(DataModel dataSet) {
        if (!(dataSet instanceof DataSet) || !dataSet.isDiscrete()) {
            throw new IllegalArgumentException("Sorry, I was expecting a discrete data set.");
        }
        return (DataSet)dataSet;
    }

    public static DataSet getContinuousDataSet(DataModel dataSet) {
        if (!(dataSet instanceof DataSet) || !dataSet.isContinuous()) {
            throw new IllegalArgumentException("Sorry, I was expecting a (tabular) continuous data set.");
        }
        return (DataSet)dataSet;
    }

    public static DataSet getMixedDataSet(DataModel dataSet) {
        if (!(dataSet instanceof DataSet)) {
            throw new IllegalArgumentException("Sorry, I was expecting a (tabular) mixed data set.");
        }
        return (DataSet)dataSet;
    }

    public static ICovarianceMatrix getCovarianceMatrix(DataModel dataModel, boolean precomputeCovariances) {
        if (dataModel == null) {
            throw new IllegalArgumentException("Expecting either a tabular dataset or a covariance matrix.");
        }
        if (dataModel instanceof ICovarianceMatrix) {
            return (ICovarianceMatrix)dataModel;
        }
        if (dataModel instanceof DataSet) {
            return SimpleDataLoader.getCovarianceMatrix((DataSet)dataModel, precomputeCovariances);
        }
        throw new IllegalArgumentException("Sorry, I was expecting either a tabular dataset or a covariance matrix.");
    }

    @NotNull
    public static ICovarianceMatrix getCovarianceMatrix(DataSet dataSet, boolean precomputeCovariances) {
        if (precomputeCovariances) {
            return new CovarianceMatrix(dataSet);
        }
        return new CovarianceMatrixOnTheFly(dataSet);
    }

    @NotNull
    public static ICovarianceMatrix getCorrelationMatrix(DataSet dataSet) {
        return new CorrelationMatrix(dataSet);
    }

    public static Knowledge loadKnowledge(File file, DelimiterType delimiter, String commentMarker) throws IOException {
        FileReader reader = new FileReader(file);
        Lineizer lineizer = new Lineizer(reader, commentMarker);
        Knowledge knowledge = SimpleDataLoader.loadKnowledge(lineizer, delimiter.getPattern());
        TetradLogger.getInstance().reset();
        return knowledge;
    }

    private static Knowledge loadKnowledge(Lineizer lineizer, Pattern delimiter) {
        String line;
        Knowledge knowledge = new Knowledge();
        String firstLine = line = lineizer.nextLine();
        if (line == null) {
            return new Knowledge();
        }
        if (line.startsWith("/knowledge")) {
            firstLine = line = lineizer.nextLine();
        }
        TetradLogger.getInstance().log("info", "\nLoading knowledge.");
        block0: while (lineizer.hasMoreLines()) {
            String to;
            String from;
            String name;
            RegexTokenizer st;
            HashSet<String> to2;
            line = firstLine == null ? lineizer.nextLine() : firstLine;
            if ("addtemporal".equalsIgnoreCase(line.trim())) {
                while (lineizer.hasMoreLines()) {
                    String token;
                    line = lineizer.nextLine();
                    if (line.startsWith("forbiddirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("requiredirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("forbiddengroup")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("requiredgroup")) {
                        firstLine = line;
                        continue block0;
                    }
                    int tier = -1;
                    RegexTokenizer st2 = new RegexTokenizer(line, delimiter, '\"');
                    if (st2.hasMoreTokens()) {
                        token = st2.nextToken();
                        boolean forbiddenWithin = false;
                        if (token.endsWith("*")) {
                            forbiddenWithin = true;
                            token = token.substring(0, token.length() - 1);
                        }
                        if ((tier = Integer.parseInt(token)) < 0) {
                            throw new IllegalArgumentException(lineizer.getLineNumber() + ": Tiers must be 0, 1, 2...");
                        }
                        if (forbiddenWithin) {
                            knowledge.setTierForbiddenWithin(tier, true);
                        }
                    }
                    while (st2.hasMoreTokens()) {
                        token = st2.nextToken();
                        if ((token = token.trim()).isEmpty()) continue;
                        String name2 = SimpleDataLoader.substitutePeriodsForSpaces(token);
                        SimpleDataLoader.addVariable(knowledge, name2);
                        knowledge.addToTier(tier, name2);
                        TetradLogger.getInstance().log("info", "Adding to tier " + tier + " " + name2);
                    }
                }
                continue;
            }
            if ("forbiddengroup".equalsIgnoreCase(line.trim())) {
                while (lineizer.hasMoreLines()) {
                    String token;
                    line = lineizer.nextLine();
                    if (line.startsWith("forbiddirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("requiredirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("addtemporal")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("requiredgroup")) {
                        firstLine = line;
                        continue block0;
                    }
                    HashSet<String> from2 = new HashSet<String>();
                    to2 = new HashSet<String>();
                    st = new RegexTokenizer(line, delimiter, '\"');
                    while (st.hasMoreTokens()) {
                        token = st.nextToken();
                        token = token.trim();
                        name = SimpleDataLoader.substitutePeriodsForSpaces(token);
                        SimpleDataLoader.addVariable(knowledge, name);
                        from2.add(name);
                    }
                    line = lineizer.nextLine();
                    st = new RegexTokenizer(line, delimiter, '\"');
                    while (st.hasMoreTokens()) {
                        token = st.nextToken();
                        token = token.trim();
                        name = SimpleDataLoader.substitutePeriodsForSpaces(token);
                        SimpleDataLoader.addVariable(knowledge, name);
                        to2.add(name);
                    }
                    KnowledgeGroup group = new KnowledgeGroup(2, from2, to2);
                    knowledge.addKnowledgeGroup(group);
                }
                continue;
            }
            if ("requiredgroup".equalsIgnoreCase(line.trim())) {
                while (lineizer.hasMoreLines()) {
                    String token;
                    line = lineizer.nextLine();
                    if (line.startsWith("forbiddirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("requiredirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("forbiddengroup")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("addtemporal")) {
                        firstLine = line;
                        continue block0;
                    }
                    HashSet<String> from3 = new HashSet<String>();
                    to2 = new HashSet();
                    st = new RegexTokenizer(line, delimiter, '\"');
                    while (st.hasMoreTokens()) {
                        token = st.nextToken();
                        token = token.trim();
                        name = SimpleDataLoader.substitutePeriodsForSpaces(token);
                        SimpleDataLoader.addVariable(knowledge, name);
                        from3.add(name);
                    }
                    line = lineizer.nextLine();
                    st = new RegexTokenizer(line, delimiter, '\"');
                    while (st.hasMoreTokens()) {
                        token = st.nextToken();
                        token = token.trim();
                        name = SimpleDataLoader.substitutePeriodsForSpaces(token);
                        SimpleDataLoader.addVariable(knowledge, name);
                        to2.add(name);
                    }
                    KnowledgeGroup group = new KnowledgeGroup(1, from3, to2);
                    knowledge.addKnowledgeGroup(group);
                }
                continue;
            }
            if ("forbiddirect".equalsIgnoreCase(line.trim())) {
                while (lineizer.hasMoreLines()) {
                    line = lineizer.nextLine();
                    if (line.startsWith("addtemporal")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("requiredirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("forbiddengroup")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("requiredgroup")) {
                        firstLine = line;
                        continue block0;
                    }
                    RegexTokenizer st3 = new RegexTokenizer(line, delimiter, '\"');
                    from = null;
                    to = null;
                    if (st3.hasMoreTokens()) {
                        from = st3.nextToken();
                    }
                    if (st3.hasMoreTokens()) {
                        to = st3.nextToken();
                    }
                    if (st3.hasMoreTokens()) {
                        throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Lines contains more than two elements.");
                    }
                    if (from == null || to == null) {
                        throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Line contains fewer than two elements.");
                    }
                    SimpleDataLoader.addVariable(knowledge, from);
                    SimpleDataLoader.addVariable(knowledge, to);
                    knowledge.setForbidden(from, to);
                }
                continue;
            }
            if ("requiredirect".equalsIgnoreCase(line.trim())) {
                while (lineizer.hasMoreLines()) {
                    line = lineizer.nextLine();
                    if (line.startsWith("forbiddirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("addtemporal")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("forbiddengroup")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("requiredgroup")) {
                        firstLine = line;
                        continue block0;
                    }
                    RegexTokenizer st4 = new RegexTokenizer(line, delimiter, '\"');
                    from = null;
                    to = null;
                    if (st4.hasMoreTokens()) {
                        from = st4.nextToken();
                    }
                    if (st4.hasMoreTokens()) {
                        to = st4.nextToken();
                    }
                    if (st4.hasMoreTokens()) {
                        throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Lines contains more than two elements.");
                    }
                    if (from == null || to == null) {
                        throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Line contains fewer than two elements.");
                    }
                    SimpleDataLoader.addVariable(knowledge, from);
                    SimpleDataLoader.addVariable(knowledge, to);
                    knowledge.removeForbidden(from, to);
                    knowledge.setRequired(from, to);
                }
                continue;
            }
            throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Expecting 'addtemporal', 'forbiddirect' or 'requiredirect'.");
        }
        return knowledge;
    }

    private static void addVariable(Knowledge knowledge, String from) {
        if (!knowledge.getVariables().contains(from)) {
            knowledge.addVariable(from);
        }
    }

    private static String substitutePeriodsForSpaces(String s) {
        return s.replaceAll(" ", ".");
    }
}

